/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.codec.decode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.abi.ABICodec;
import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.abi.EventEncoder;
import org.fisco.bcos.sdk.abi.wrapper.ABICodecObject;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinitionFactory;
import org.fisco.bcos.sdk.abi.wrapper.ABIObject;
import org.fisco.bcos.sdk.abi.wrapper.ABIObjectFactory;
import org.fisco.bcos.sdk.abi.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.rlp.RlpDecoder;
import org.fisco.bcos.sdk.rlp.RlpList;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.codec.decode.TransactionDecoderInterface;
import org.fisco.bcos.sdk.transaction.model.dto.TransactionResponse;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.transaction.model.exception.TransactionException;
import org.fisco.bcos.sdk.transaction.model.po.RawTransaction;
import org.fisco.bcos.sdk.transaction.tools.JsonUtils;
import org.fisco.bcos.sdk.transaction.tools.ReceiptStatusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionDecoderService
implements TransactionDecoderInterface {
    protected static Logger logger = LoggerFactory.getLogger(TransactionDecoderService.class);
    private CryptoSuite cryptoSuite;
    private final ABICodec abiCodec;
    private EventEncoder eventEncoder;

    public TransactionDecoderService(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
        this.abiCodec = new ABICodec(cryptoSuite);
        this.eventEncoder = new EventEncoder(cryptoSuite);
    }

    @Override
    public String decodeReceiptMessage(String output) {
        return ReceiptStatusUtil.decodeReceiptMessage(output);
    }

    @Override
    public TransactionResponse decodeReceiptWithValues(String abi, String functionName, TransactionReceipt transactionReceipt) throws IOException, ABICodecException, TransactionException {
        TransactionResponse response = this.decodeReceiptWithoutValues(abi, transactionReceipt);
        if (transactionReceipt.getInput() != null) {
            Pair<List<Object>, List<ABIObject>> inputObject = this.abiCodec.decodeTransactionInput(abi, transactionReceipt.getInput());
            String inputValues = JsonUtils.toJson(inputObject.getLeft());
            response.setInputData(inputValues);
            response.setInputObject((List)inputObject.getLeft());
            response.setInputABIObject((List)inputObject.getRight());
        }
        if (transactionReceipt.getStatus().equals("0x0")) {
            Pair<List<Object>, List<ABIObject>> returnObject = this.abiCodec.decodeMethodAndGetOutputObject(abi, functionName, transactionReceipt.getOutput());
            String values = JsonUtils.toJson(returnObject.getLeft());
            response.setReturnObject((List)returnObject.getLeft());
            response.setReturnABIObject((List)returnObject.getRight());
            response.setValues(values);
        }
        return response;
    }

    @Override
    public TransactionResponse decodeReceiptWithoutValues(String abi, TransactionReceipt transactionReceipt) throws TransactionException, IOException, ABICodecException {
        TransactionResponse response = this.decodeReceiptStatus(transactionReceipt);
        response.setTransactionReceipt(transactionReceipt);
        response.setContractAddress(transactionReceipt.getContractAddress());
        if (!transactionReceipt.getStatus().equals("0x0")) {
            return response;
        }
        String events = JsonUtils.toJson(this.decodeEvents(abi, transactionReceipt.getLogs()));
        response.setEvents(events);
        return response;
    }

    @Override
    @Deprecated
    public TransactionResponse decodeReceiptWithoutOutputValues(String abi, TransactionReceipt transactionReceipt, String constructorCode) throws TransactionException, IOException, ABICodecException {
        TransactionResponse response = this.decodeReceiptWithoutValues(abi, transactionReceipt);
        if (transactionReceipt.getInput() != null && transactionReceipt.isStatusOK()) {
            Pair<List<Object>, List<ABIObject>> inputObject = this.abiCodec.decodeMethodInput(abi, transactionReceipt.getInput(), "constructor", constructorCode);
            String inputValues = JsonUtils.toJson(inputObject.getLeft());
            response.setInputData(inputValues);
            response.setInputObject((List)inputObject.getLeft());
            response.setInputABIObject((List)inputObject.getRight());
        }
        return response;
    }

    @Override
    public TransactionResponse decodeConstructorReceipt(String abi, String binary, TransactionReceipt transactionReceipt) throws TransactionException, IOException, ABICodecException {
        TransactionResponse response = this.decodeReceiptWithoutValues(abi, transactionReceipt);
        if (transactionReceipt.getInput() != null && transactionReceipt.isStatusOK()) {
            Pair<List<Object>, List<ABIObject>> inputObject = this.abiCodec.decodeConstructorInput(abi, binary, transactionReceipt.getInput(), "constructor");
            String inputValues = JsonUtils.toJson(inputObject.getLeft());
            response.setInputData(inputValues);
            response.setInputObject((List)inputObject.getLeft());
            response.setInputABIObject((List)inputObject.getRight());
        }
        return response;
    }

    @Override
    public TransactionResponse decodeReceiptStatus(TransactionReceipt receipt) {
        TransactionResponse response = new TransactionResponse();
        try {
            RetCode retCode = ReceiptParser.parseTransactionReceipt(receipt);
            response.setReturnCode(retCode.getCode());
            response.setReceiptMessages(retCode.getMessage());
            response.setReturnMessage(retCode.getMessage());
        }
        catch (ContractException e) {
            response.setReturnCode(e.getErrorCode());
            response.setReceiptMessages(e.getMessage());
            response.setReturnMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public Map<String, List<List<Object>>> decodeEvents(String abi, List<TransactionReceipt.Logs> logs) throws ABICodecException {
        ABIDefinitionFactory abiDefinitionFactory = new ABIDefinitionFactory(this.cryptoSuite);
        ContractABIDefinition contractABIDefinition = abiDefinitionFactory.loadABI(abi);
        Map<String, List<ABIDefinition>> eventsMap = contractABIDefinition.getEvents();
        HashMap<String, List<List<Object>>> result = new HashMap<String, List<List<Object>>>();
        eventsMap.forEach((name, events) -> {
            for (ABIDefinition abiDefinition : events) {
                ABIObjectFactory abiObjectFactory = new ABIObjectFactory();
                ABIObject outputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
                ABICodecObject abiCodecObject = new ABICodecObject();
                for (TransactionReceipt.Logs log : logs) {
                    String eventTopic = this.eventEncoder.buildEventSignature(this.decodeMethodSign(abiDefinition));
                    if (log.getTopics().isEmpty() || !log.getTopics().contains(eventTopic)) continue;
                    try {
                        List<Object> list = abiCodecObject.decodeJavaObject(outputObject, log.getData());
                        if (result.containsKey(name)) {
                            ((List)result.get(name)).add(list);
                            continue;
                        }
                        ArrayList<List<Object>> l = new ArrayList<List<Object>>();
                        l.add(list);
                        result.put((String)name, (List<List<Object>>)l);
                    }
                    catch (Exception e) {
                        logger.error(" exception in decodeEventToObject : {}", (Object)e.getMessage());
                    }
                }
            }
        });
        return result;
    }

    @Override
    public RawTransaction decode(byte[] encodedTx) {
        return TransactionDecoderService.fromRlpValues(encodedTx);
    }

    public static RawTransaction fromRlpValues(byte[] encoded) {
        try {
            RlpList rlpList = RlpDecoder.decode(encoded);
            RlpList values = (RlpList)rlpList.getValues().get(0);
            RlpString randomID = (RlpString)values.getValues().get(0);
            RlpString gasPrice = (RlpString)values.getValues().get(1);
            RlpString gasLimit = (RlpString)values.getValues().get(2);
            RlpString blockLimit = (RlpString)values.getValues().get(3);
            RlpString to = (RlpString)values.getValues().get(4);
            RlpString value = (RlpString)values.getValues().get(5);
            RlpString data = (RlpString)values.getValues().get(6);
            RlpString chainID = (RlpString)values.getValues().get(7);
            RlpString groupID = (RlpString)values.getValues().get(8);
            RlpString extraData = (RlpString)values.getValues().get(9);
            RawTransaction rawTransaction = RawTransaction.createTransaction(randomID.asPositiveBigInteger(), gasPrice.asPositiveBigInteger(), gasLimit.asPositiveBigInteger(), blockLimit.asPositiveBigInteger(), to.asString(), value.asPositiveBigInteger(), data.asString(), chainID.asPositiveBigInteger(), groupID.asPositiveBigInteger(), extraData.asString());
            logger.debug(" rawTransaction: {}", (Object)rawTransaction);
            return rawTransaction;
        }
        catch (Exception e) {
            logger.warn(" rawTransaction: {}", (Throwable)e);
            return null;
        }
    }

    private String decodeMethodSign(ABIDefinition ABIDefinition2) {
        List<ABIDefinition.NamedType> inputTypes = ABIDefinition2.getInputs();
        StringBuilder methodSign = new StringBuilder();
        methodSign.append(ABIDefinition2.getName());
        methodSign.append("(");
        String params = inputTypes.stream().map(ABIDefinition.NamedType::getType).collect(Collectors.joining(","));
        methodSign.append(params);
        methodSign.append(")");
        return methodSign.toString();
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }
}

