/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.model.po;

import java.io.Serializable;
import java.math.BigInteger;
import org.fisco.bcos.sdk.utils.Numeric;

public class RawTransaction
implements Serializable {
    private static final long serialVersionUID = -5580814755985097996L;
    private BigInteger randomid;
    private BigInteger gasPrice;
    private BigInteger gasLimit;
    private BigInteger blockLimit;
    private String to;
    private BigInteger value;
    private String data;
    private BigInteger fiscoChainId;
    private BigInteger groupId;
    private String extraData;
    private BigInteger version;

    protected RawTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value, String data, BigInteger fiscoChainId, BigInteger groupId, String extraData) {
        this.randomid = randomid;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.blockLimit = blockLimit;
        this.fiscoChainId = fiscoChainId;
        this.groupId = groupId;
        this.extraData = extraData;
        this.to = to;
        this.value = value;
        if (data != null) {
            this.data = Numeric.cleanHexPrefix(data);
        }
    }

    public static RawTransaction createContractTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, BigInteger value, String init, BigInteger chainId, BigInteger groupId, String extraData) {
        return new RawTransaction(randomid, gasPrice, gasLimit, blockLimit, "", value, init, chainId, groupId, extraData);
    }

    public static RawTransaction createTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value, String data, BigInteger chainId, BigInteger groupId, String extraData) {
        return new RawTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data, chainId, groupId, extraData);
    }

    public BigInteger getRandomid() {
        return this.randomid;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public BigInteger getBlockLimit() {
        return this.blockLimit;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getData() {
        return this.data;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getGroupId() {
        return this.groupId;
    }

    public void setGroupId(BigInteger groupId) {
        this.groupId = groupId;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public BigInteger getFiscoChainId() {
        return this.fiscoChainId;
    }

    public void setFiscoChainId(BigInteger fiscoChainId) {
        this.fiscoChainId = fiscoChainId;
    }

    public String toString() {
        return "RawTransaction{randomid=" + this.randomid + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", blockLimit=" + this.blockLimit + ", to='" + this.to + '\'' + ", value=" + this.value + ", data='" + this.data + '\'' + ", fiscoChainId=" + this.fiscoChainId + ", groupId=" + this.groupId + ", extraData='" + this.extraData + '\'' + ", version=" + this.version + '}';
    }
}

