/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.Event;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple1;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple3;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.Contract;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.eventsub.EventCallback;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.StringUtils;

public class TableTest
extends Contract {
    public static final String[] BINARY_ARRAY = new String[]{"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", "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", "611d0481611b1f565b9050919050565b60006040820190508181036000830152611d2481611b1f565b90508181036020830152611d388184611ab3565b905092915050565b60006020820190508181036000830152611d5981611b56565b9050919050565b60006040820190508181036000830152611d7981611b56565b90508181036020830152611d8d8184611ab3565b905092915050565b60006020820190508181036000830152611dae81611b8d565b9050919050565b60006040820190508181036000830152611dce81611b8d565b9050611ddd6020830184611aa4565b92915050565b6000604051905081810181811067ffffffffffffffff82111715611e0657600080fd5b8060405250919050565b600067ffffffffffffffff821115611e2757600080fd5b601f19601f8301169050602081019050919050565b6000602082019050919050565b6000602082019050919050565b600081519050919050565b600081519050919050565b600081519050919050565b600081519050919050565b6000602082019050919050565b6000602082019050919050565b600073ffffffffffffffffffffffffffffffffffffffff82169050919050565b6000819050919050565b6000611ed182611e9c565b9050919050565b6000611ee382611e9c565b9050919050565b6000611ef582611e9c565b9050919050565b6000611f0782611e9c565b9050919050565b6000819050919050565b6000611f2382611e9c565b9050919050565b6000611f3582611e9c565b9050919050565b82818337600083830152505050565b60005b83811015611f69578082015181840152602081019050611f4e565b83811115611f78576000848401525b50505050565b6000601f19601f83011690509190505600a265627a7a72305820326d8c9bff5d11da12345991d4e04543ea54002f0b793b8a9eebe1a73d9626fd6c6578706572696d656e74616cf50037"};
    public static final String BINARY = StringUtils.joinAll("", BINARY_ARRAY);
    public static final String[] SM_BINARY_ARRAY = new String[]{"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", "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", "611d0481611b1f565b9050919050565b60006040820190508181036000830152611d2481611b1f565b9050611d336020830184611aa4565b92915050565b60006020820190508181036000830152611d5281611b56565b9050919050565b60006040820190508181036000830152611d7281611b56565b90508181036020830152611d868184611ab3565b905092915050565b60006020820190508181036000830152611da781611b8d565b9050919050565b60006040820190508181036000830152611dc781611b8d565b90508181036020830152611ddb8184611ab3565b905092915050565b6000604051905081810181811067ffffffffffffffff82111715611e0657600080fd5b8060405250919050565b600067ffffffffffffffff821115611e2757600080fd5b601f19601f8301169050602081019050919050565b6000602082019050919050565b6000602082019050919050565b600081519050919050565b600081519050919050565b600081519050919050565b600081519050919050565b6000602082019050919050565b6000602082019050919050565b600073ffffffffffffffffffffffffffffffffffffffff82169050919050565b6000819050919050565b6000611ed182611e9c565b9050919050565b6000611ee382611e9c565b9050919050565b6000611ef582611e9c565b9050919050565b6000611f0782611e9c565b9050919050565b6000819050919050565b6000611f2382611e9c565b9050919050565b6000611f3582611e9c565b9050919050565b82818337600083830152505050565b60005b83811015611f69578082015181840152602081019050611f4e565b83811115611f78576000848401525b50505050565b6000601f19601f83011690509190505600a265627a7a72305820db0a549971d034d94e7b75e5593cc39bc06456ce5835ee0dc0bb6547d175f4146c6578706572696d656e74616cf50037"};
    public static final String SM_BINARY = StringUtils.joinAll("", SM_BINARY_ARRAY);
    public static final String[] ABI_ARRAY = new String[]{"[{\"constant\":false,\"inputs\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"item_id\",\"type\":\"int256\"},{\"name\":\"item_name\",\"type\":\"string\"}],\"name\":\"update\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"item_id\",\"type\":\"int256\"}],\"name\":\"remove\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"item_id\",\"type\":\"int256\"},{\"name\":\"item_name\",\"type\":\"string\"}],\"name\":\"insert\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"name\",\"type\":\"string\"}],\"name\":\"select\",\"outputs\":[{\"name\":\"\",\"type\":\"string[]\"},{\"name\":\"\",\"type\":\"int256[]\"},{\"name\":\"\",\"type\":\"string[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"count\",\"type\":\"int256\"}],\"name\":\"CreateResult\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"count\",\"type\":\"int256\"}],\"name\":\"InsertResult\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"count\",\"type\":\"int256\"}],\"name\":\"UpdateResult\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"count\",\"type\":\"int256\"}],\"name\":\"RemoveResult\",\"type\":\"event\"}]"};
    public static final String ABI = StringUtils.joinAll("", ABI_ARRAY);
    public static final String FUNC_UPDATE = "update";
    public static final String FUNC_REMOVE = "remove";
    public static final String FUNC_INSERT = "insert";
    public static final String FUNC_SELECT = "select";
    public static final Event CREATERESULT_EVENT = new Event("CreateResult", Arrays.asList(new TypeReference<Int256>(){}));
    public static final Event INSERTRESULT_EVENT = new Event("InsertResult", Arrays.asList(new TypeReference<Int256>(){}));
    public static final Event UPDATERESULT_EVENT = new Event("UpdateResult", Arrays.asList(new TypeReference<Int256>(){}));
    public static final Event REMOVERESULT_EVENT = new Event("RemoveResult", Arrays.asList(new TypeReference<Int256>(){}));

    protected TableTest(String contractAddress, Client client, CryptoKeyPair credential) {
        super(TableTest.getBinary(client.getCryptoSuite()), contractAddress, client, credential);
    }

    public static String getBinary(CryptoSuite cryptoSuite) {
        return cryptoSuite.getCryptoTypeConfig() == 0 ? BINARY : SM_BINARY;
    }

    public TransactionReceipt update(String name, BigInteger item_id, String item_name) {
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public byte[] update(String name, BigInteger item_id, String item_name, TransactionCallback callback) {
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForUpdate(String name, BigInteger item_id, String item_name) {
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple3<String, BigInteger, String> getUpdateInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Int256>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple3<String, BigInteger, String>((String)results.get(0).getValue(), (BigInteger)results.get(1).getValue(), (String)results.get(2).getValue());
    }

    public Tuple1<BigInteger> getUpdateOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt remove(String name, BigInteger item_id) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(name), new Int256(item_id)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public byte[] remove(String name, BigInteger item_id, TransactionCallback callback) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(name), new Int256(item_id)), Collections.emptyList());
        return this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForRemove(String name, BigInteger item_id) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(name), new Int256(item_id)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple2<String, BigInteger> getRemoveInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, BigInteger>((String)results.get(0).getValue(), (BigInteger)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getRemoveOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt insert(String name, BigInteger item_id, String item_name) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public byte[] insert(String name, BigInteger item_id, String item_name, TransactionCallback callback) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForInsert(String name, BigInteger item_id, String item_name) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(name), new Int256(item_id), new Utf8String(item_name)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple3<String, BigInteger, String> getInsertInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Int256>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple3<String, BigInteger, String>((String)results.get(0).getValue(), (BigInteger)results.get(1).getValue(), (String)results.get(2).getValue());
    }

    public Tuple1<BigInteger> getInsertOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public Tuple3<List<String>, List<BigInteger>, List<String>> select(String name) throws ContractException {
        Function function = new Function(FUNC_SELECT, Arrays.asList(new Utf8String(name)), Arrays.asList(new TypeReference<DynamicArray<Utf8String>>(){}, new TypeReference<DynamicArray<Int256>>(){}, new TypeReference<DynamicArray<Utf8String>>(){}));
        List<Type> results = this.executeCallWithMultipleValueReturn(function);
        return new Tuple3<List<String>, List<BigInteger>, List<String>>(TableTest.convertToNative((List)results.get(0).getValue()), TableTest.convertToNative((List)results.get(1).getValue()), TableTest.convertToNative((List)results.get(2).getValue()));
    }

    public List<CreateResultEventResponse> getCreateResultEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(CREATERESULT_EVENT, transactionReceipt);
        ArrayList<CreateResultEventResponse> responses = new ArrayList<CreateResultEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            CreateResultEventResponse typedResponse = new CreateResultEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.count = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public void subscribeCreateResultEvent(String fromBlock, String toBlock, List<String> otherTopics, EventCallback callback) {
        String topic0 = this.eventEncoder.encode(CREATERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, fromBlock, toBlock, otherTopics, callback);
    }

    public void subscribeCreateResultEvent(EventCallback callback) {
        String topic0 = this.eventEncoder.encode(CREATERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, callback);
    }

    public List<InsertResultEventResponse> getInsertResultEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(INSERTRESULT_EVENT, transactionReceipt);
        ArrayList<InsertResultEventResponse> responses = new ArrayList<InsertResultEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InsertResultEventResponse typedResponse = new InsertResultEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.count = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public void subscribeInsertResultEvent(String fromBlock, String toBlock, List<String> otherTopics, EventCallback callback) {
        String topic0 = this.eventEncoder.encode(INSERTRESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, fromBlock, toBlock, otherTopics, callback);
    }

    public void subscribeInsertResultEvent(EventCallback callback) {
        String topic0 = this.eventEncoder.encode(INSERTRESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, callback);
    }

    public List<UpdateResultEventResponse> getUpdateResultEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(UPDATERESULT_EVENT, transactionReceipt);
        ArrayList<UpdateResultEventResponse> responses = new ArrayList<UpdateResultEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpdateResultEventResponse typedResponse = new UpdateResultEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.count = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public void subscribeUpdateResultEvent(String fromBlock, String toBlock, List<String> otherTopics, EventCallback callback) {
        String topic0 = this.eventEncoder.encode(UPDATERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, fromBlock, toBlock, otherTopics, callback);
    }

    public void subscribeUpdateResultEvent(EventCallback callback) {
        String topic0 = this.eventEncoder.encode(UPDATERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, callback);
    }

    public List<RemoveResultEventResponse> getRemoveResultEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(REMOVERESULT_EVENT, transactionReceipt);
        ArrayList<RemoveResultEventResponse> responses = new ArrayList<RemoveResultEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemoveResultEventResponse typedResponse = new RemoveResultEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.count = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public void subscribeRemoveResultEvent(String fromBlock, String toBlock, List<String> otherTopics, EventCallback callback) {
        String topic0 = this.eventEncoder.encode(REMOVERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, fromBlock, toBlock, otherTopics, callback);
    }

    public void subscribeRemoveResultEvent(EventCallback callback) {
        String topic0 = this.eventEncoder.encode(REMOVERESULT_EVENT);
        this.subscribeEvent(ABI, BINARY, topic0, callback);
    }

    public static TableTest load(String contractAddress, Client client, CryptoKeyPair credential) {
        return new TableTest(contractAddress, client, credential);
    }

    public static TableTest deploy(Client client, CryptoKeyPair credential) throws ContractException {
        return TableTest.deploy(TableTest.class, client, credential, TableTest.getBinary(client.getCryptoSuite()), "");
    }

    public static class RemoveResultEventResponse {
        public TransactionReceipt.Logs log;
        public BigInteger count;
    }

    public static class UpdateResultEventResponse {
        public TransactionReceipt.Logs log;
        public BigInteger count;
    }

    public static class InsertResultEventResponse {
        public TransactionReceipt.Logs log;
        public BigInteger count;
    }

    public static class CreateResultEventResponse {
        public TransactionReceipt.Logs log;
        public BigInteger count;
    }
}

