/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;

public class StaticArray<T extends Type>
extends Array<T> {
    public static int MAX_SIZE_OF_STATIC_ARRAY = 1024;
    private Integer expectedSize;

    @SafeVarargs
    public StaticArray(T ... values) {
        super(values[0].getTypeAsString() + "[" + values.length + "]", values);
        this.isValid();
    }

    @SafeVarargs
    public StaticArray(int expectedSize, T ... values) {
        super(values[0].getTypeAsString() + "[" + values.length + "]", values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    public StaticArray(List<T> values) {
        super(((Type)values.get(0)).getTypeAsString() + "[" + values.size() + "]", values);
        this.isValid();
    }

    public StaticArray(int expectedSize, List<T> values) {
        super(((Type)values.get(0)).getTypeAsString() + "[" + values.size() + "]", values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    private void isValid() {
        if (this.expectedSize == null && this.value.size() > MAX_SIZE_OF_STATIC_ARRAY) {
            throw new UnsupportedOperationException("Static arrays with a length greater than 1024 are not supported.");
        }
        if (this.expectedSize != null && this.value.size() != this.expectedSize.intValue()) {
            throw new UnsupportedOperationException("Expected array of type [" + this.getClass().getSimpleName() + "] to have [" + this.expectedSize + "] elements.");
        }
    }

    @Override
    public boolean dynamicType() {
        Type obj = (Type)this.value.get(0);
        if (obj instanceof StaticArray) {
            return obj.dynamicType();
        }
        if (obj instanceof NumericType || obj instanceof Address || obj instanceof Bool || obj instanceof Bytes) {
            return false;
        }
        if (obj instanceof DynamicBytes || obj instanceof Utf8String || obj instanceof DynamicArray) {
            return true;
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + obj.getClass());
    }

    @Override
    public int offset() {
        if (this.dynamicType()) {
            return 1;
        }
        Object obj = this.value.get(0);
        if (obj instanceof StaticArray) {
            return ((Type)obj).offset() * this.getValue().size();
        }
        return this.getValue().size();
    }
}

