/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.wrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.Uint256;
import org.fisco.bcos.sdk.abi.wrapper.ABICodecObject;
import org.fisco.bcos.sdk.abi.wrapper.ABIObject;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABICodecJsonWrapper {
    public static final String Base64EncodedDataPrefix = "base64://";
    public static final String HexEncodedDataPrefix = "hex://";
    private static final Logger logger = LoggerFactory.getLogger(ABICodecJsonWrapper.class);
    private ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private boolean decodeBytesDataAsHexFormat = false;

    public ABICodecJsonWrapper() {
    }

    public ABICodecJsonWrapper(boolean decodeBytesDataAsHexFormat) {
        this.decodeBytesDataAsHexFormat = decodeBytesDataAsHexFormat;
    }

    public boolean isDecodeBytesDataAsHexFormat() {
        return this.decodeBytesDataAsHexFormat;
    }

    public void setDecodeBytesDataAsHexFormat(boolean decodeBytesDataAsHexFormat) {
        this.decodeBytesDataAsHexFormat = decodeBytesDataAsHexFormat;
    }

    private void errorReport(String path, String expected, String actual) throws InvalidParameterException {
        String errorMessage = "Arguments mismatch: " + path + ", expected: " + expected + ", actual: " + actual;
        logger.error(errorMessage);
        throw new InvalidParameterException(errorMessage);
    }

    private void errorReport(String errorMessage) {
        logger.error(errorMessage);
        throw new InvalidParameterException(errorMessage);
    }

    private void errorReport(String path, String expected, String actual, String exceptionReason) throws InvalidParameterException {
        String errorMessage = "Arguments mismatch: " + path + ", expected: " + expected + ", actual: " + actual + ", exception reason:" + exceptionReason;
        logger.error(errorMessage);
        throw new InvalidParameterException(errorMessage);
    }

    private ABIObject encodeNode(String path, ABIObject template, JsonNode node) {
        ABIObject abiObject = template.newObject();
        switch (abiObject.getType()) {
            case VALUE: {
                if (!node.isValueNode()) {
                    this.errorReport(path, abiObject.getType().toString(), node.getNodeType().toString());
                }
                switch (template.getValueType()) {
                    case BOOL: {
                        if (!node.isBoolean()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        abiObject.setBoolValue(new Bool(node.asBoolean()));
                        break;
                    }
                    case INT: {
                        if (!node.isNumber() && !node.isBigInteger()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        if (node.isNumber()) {
                            abiObject.setNumericValue(new Int256(node.asLong()));
                            break;
                        }
                        abiObject.setNumericValue(new Int256(node.bigIntegerValue()));
                        break;
                    }
                    case UINT: {
                        if (!node.isNumber() && !node.isBigInteger()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        if (node.isNumber()) {
                            abiObject.setNumericValue(new Uint256(node.asLong()));
                            break;
                        }
                        abiObject.setNumericValue(new Uint256(node.bigIntegerValue()));
                        break;
                    }
                    case ADDRESS: {
                        if (!node.isTextual()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        try {
                            abiObject.setAddressValue(new Address(node.asText()));
                        }
                        catch (Exception e) {
                            this.errorReport("Invalid address value", template.getValueType().toString(), node.asText());
                        }
                        break;
                    }
                    case BYTES: {
                        String value;
                        byte[] bytesValue;
                        if (!node.isTextual()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        if ((bytesValue = ABICodecJsonWrapper.tryDecodeInputData(value = node.asText())) == null) {
                            bytesValue = value.getBytes();
                        }
                        if (abiObject.getBytesLength() > 0 && bytesValue.length != abiObject.getBytesLength()) {
                            this.errorReport("Invalid input bytes, required length: " + abiObject.getBytesLength() + ", input data length:" + bytesValue.length);
                        }
                        abiObject.setBytesValue(new Bytes(bytesValue.length, bytesValue));
                        break;
                    }
                    case DBYTES: {
                        String value;
                        byte[] bytesValue;
                        if (!node.isTextual()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        if ((bytesValue = ABICodecJsonWrapper.tryDecodeInputData(value = node.asText())) == null) {
                            bytesValue = value.getBytes();
                        }
                        abiObject.setDynamicBytesValue(new DynamicBytes(bytesValue));
                        break;
                    }
                    case STRING: {
                        if (!node.isTextual()) {
                            this.errorReport(path, template.getValueType().toString(), node.getNodeType().toString());
                        }
                        abiObject.setStringValue(new Utf8String(node.asText()));
                    }
                }
                break;
            }
            case LIST: {
                if (!node.isArray()) {
                    this.errorReport(path, abiObject.getType().toString(), node.getNodeType().toString());
                }
                if (abiObject.getListType() == ABIObject.ListType.FIXED && node.size() != abiObject.getListLength()) {
                    this.errorReport("fixed list arguments size", String.valueOf(abiObject.getListLength()), String.valueOf(node.size()));
                }
                int i = 0;
                Iterator iterator = node.iterator();
                while (iterator.hasNext()) {
                    abiObject.getListValues().add(this.encodeNode(path + ".<" + String.valueOf(i) + ">", abiObject.getListValueType(), (JsonNode)iterator.next()));
                }
                break;
            }
            case STRUCT: {
                if (!node.isArray() && !node.isObject()) {
                    this.errorReport(path, abiObject.getType().toString(), node.getNodeType().toString());
                }
                if (node.size() != abiObject.getStructFields().size()) {
                    this.errorReport("struct arguments size", String.valueOf(abiObject.getListLength()), String.valueOf(node.size()));
                }
                if (node.isArray()) {
                    for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                        ABIObject field = abiObject.getStructFields().get(i);
                        abiObject.getStructFields().set(i, this.encodeNode(path + "." + field.getName(), field, node.get(i)));
                    }
                } else {
                    for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
                        ABIObject field = abiObject.getStructFields().get(i);
                        JsonNode structNode = node.get(field.getName());
                        if (structNode == null) {
                            this.errorReport(path + "miss field value, field name: " + field.getName(), template.getValueType().toString(), node.getNodeType().toString());
                        }
                        abiObject.getStructFields().set(i, this.encodeNode(path + "." + field.getName(), field, structNode));
                    }
                }
                break;
            }
        }
        return abiObject;
    }

    public static byte[] tryDecodeInputData(String inputData) {
        if (inputData.startsWith(Base64EncodedDataPrefix)) {
            return Base64.getDecoder().decode(inputData.substring(Base64EncodedDataPrefix.length()));
        }
        if (inputData.startsWith(HexEncodedDataPrefix)) {
            String hexString = inputData.substring(HexEncodedDataPrefix.length());
            if (hexString.startsWith("0x")) {
                return Hex.decode(hexString.substring(2));
            }
            return Hex.decode(hexString);
        }
        if (inputData.startsWith("0x")) {
            return Hex.decode(inputData.substring(2));
        }
        try {
            return Hex.decode(inputData);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ABIObject encode(ABIObject template, List<String> inputs) throws IOException {
        abiObject = template.newObject();
        if (inputs.size() != abiObject.getStructFields().size()) {
            this.errorReport("arguments size", String.valueOf(abiObject.getStructFields().size()), String.valueOf(inputs.size()));
        }
        for (i = 0; i < abiObject.getStructFields().size(); ++i) {
            argObject = abiObject.getStructFields().get(i).newObject();
            value = inputs.get(i);
            switch (1.$SwitchMap$org$fisco$bcos$sdk$abi$wrapper$ABIObject$ObjectType[argObject.getType().ordinal()]) {
                case 1: {
                    try {
                        switch (1.$SwitchMap$org$fisco$bcos$sdk$abi$wrapper$ABIObject$ValueType[argObject.getValueType().ordinal()]) {
                            case 1: {
                                argObject.setBoolValue(new Bool(Boolean.valueOf(value)));
                                ** break;
                            }
                            case 3: {
                                argObject.setNumericValue(new Uint256(Numeric.decodeQuantity(value)));
                                ** break;
                            }
                            case 2: {
                                argObject.setNumericValue(new Int256(Numeric.decodeQuantity(value)));
                                ** break;
                            }
                            case 4: {
                                argObject.setAddressValue(new Address(value));
                                ** break;
                            }
                            case 5: {
                                bytesValue = ABICodecJsonWrapper.tryDecodeInputData(value);
                                if (bytesValue == null) {
                                    bytesValue = value.getBytes();
                                }
                                if (argObject.getBytesLength() > 0 && bytesValue.length != argObject.getBytesLength()) {
                                    this.errorReport("Invalid input bytes, required length: " + argObject.getBytesLength() + ", input data length:" + bytesValue.length);
                                }
                                argObject.setBytesValue(new Bytes(bytesValue.length, bytesValue));
                                ** break;
                            }
                            case 6: {
                                bytesValue = ABICodecJsonWrapper.tryDecodeInputData(value);
                                if (bytesValue == null) {
                                    bytesValue = value.getBytes();
                                }
                                argObject.setDynamicBytesValue(new DynamicBytes(bytesValue));
                                ** break;
                            }
                            case 7: {
                                argObject.setStringValue(new Utf8String(value));
                                ** break;
                            }
                        }
                        throw new UnsupportedOperationException("Unrecognized valueType: " + (Object)argObject.getValueType());
lbl41:
                        // 7 sources

                    }
                    catch (Exception e) {
                        ABICodecJsonWrapper.logger.error(" e: {}, argsObject: {}", (Object)e.getMessage(), (Object)argObject.toString());
                        this.errorReport("ROOT", argObject.getValueType().toString(), value, e.getMessage());
                    }
                    break;
                }
                case 2: 
                case 3: {
                    argNode = this.objectMapper.readTree(value.getBytes());
                    argObject = this.encodeNode("ROOT", argObject, argNode);
                    break;
                }
            }
            abiObject.getStructFields().set(i, argObject);
        }
        return abiObject;
    }

    public JsonNode decode(ABIObject abiObject) {
        JsonNodeFactory jsonNodeFactory = this.objectMapper.getNodeFactory();
        switch (abiObject.getType()) {
            case VALUE: {
                switch (abiObject.getValueType()) {
                    case BOOL: {
                        return jsonNodeFactory.booleanNode(abiObject.getBoolValue().getValue().booleanValue());
                    }
                    case INT: 
                    case UINT: {
                        return jsonNodeFactory.numberNode(abiObject.getNumericValue().getValue());
                    }
                    case ADDRESS: {
                        return jsonNodeFactory.textNode(abiObject.getAddressValue().toString());
                    }
                    case BYTES: {
                        byte[] value = abiObject.getBytesValue().getValue();
                        if (this.decodeBytesDataAsHexFormat) {
                            return jsonNodeFactory.textNode("0x" + Hex.toHexString(value));
                        }
                        return jsonNodeFactory.binaryNode(abiObject.getBytesValue().getValue());
                    }
                    case DBYTES: {
                        byte[] value = abiObject.getDynamicBytesValue().getValue();
                        if (this.decodeBytesDataAsHexFormat) {
                            return jsonNodeFactory.textNode("0x" + Hex.toHexString(value));
                        }
                        return jsonNodeFactory.binaryNode(abiObject.getDynamicBytesValue().getValue());
                    }
                    case STRING: {
                        return jsonNodeFactory.textNode(abiObject.getStringValue().getValue());
                    }
                }
                break;
            }
            case LIST: {
                ArrayNode arrayNode = jsonNodeFactory.arrayNode();
                for (ABIObject listObject : abiObject.getListValues()) {
                    arrayNode.add(this.decode(listObject));
                }
                return arrayNode;
            }
            case STRUCT: {
                ArrayNode structNode = jsonNodeFactory.arrayNode();
                for (ABIObject listObject : abiObject.getStructFields()) {
                    structNode.add(this.decode(listObject));
                }
                return structNode;
            }
        }
        return null;
    }

    public List<String> decode(ABIObject template, String buffer) {
        if (logger.isTraceEnabled()) {
            logger.trace(" ABIObject: {}, abi: {}", (Object)template.toString(), (Object)buffer);
        }
        buffer = Numeric.cleanHexPrefix(buffer);
        ABIObject abiObject = template.decode(buffer);
        JsonNode jsonNode = this.decode(abiObject);
        ArrayList<String> result = new ArrayList<String>();
        block12: for (int i = 0; i < abiObject.getStructFields().size(); ++i) {
            ABIObject argObject = abiObject.getStructFields().get(i);
            JsonNode argNode = jsonNode.get(i);
            switch (argObject.getType()) {
                case VALUE: {
                    switch (argObject.getValueType()) {
                        case BOOL: {
                            result.add(String.valueOf(argObject.getBoolValue().getValue()));
                            continue block12;
                        }
                        case INT: 
                        case UINT: {
                            result.add(argObject.getNumericValue().getValue().toString());
                            continue block12;
                        }
                        case ADDRESS: {
                            result.add(String.valueOf(argObject.getAddressValue().toString()));
                            continue block12;
                        }
                        case BYTES: {
                            String hexString;
                            byte[] value = ABICodecObject.formatBytesN(argObject);
                            if (this.decodeBytesDataAsHexFormat) {
                                hexString = Hex.toHexString(value);
                                result.add("0x" + hexString);
                                continue block12;
                            }
                            byte[] base64Bytes = Base64.getEncoder().encode(value);
                            result.add(Base64EncodedDataPrefix + new String(base64Bytes));
                            continue block12;
                        }
                        case DBYTES: {
                            String hexString;
                            byte[] value = argObject.getDynamicBytesValue().getValue();
                            if (this.decodeBytesDataAsHexFormat) {
                                hexString = Hex.toHexString(value);
                                result.add("0x" + hexString);
                                continue block12;
                            }
                            byte[] base64Bytes = Base64.getEncoder().encode(value);
                            result.add(Base64EncodedDataPrefix + new String(base64Bytes));
                            continue block12;
                        }
                        case STRING: {
                            result.add(String.valueOf(argObject.getStringValue().getValue()));
                            continue block12;
                        }
                    }
                    throw new UnsupportedOperationException(" Unsupported valueType: " + (Object)((Object)argObject.getValueType()));
                }
                case LIST: 
                case STRUCT: {
                    result.add(argNode.toPrettyString());
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException(" Unsupported objectType: " + (Object)((Object)argObject.getType()));
                }
            }
        }
        return result;
    }
}

