/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.channel;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.fisco.bcos.sdk.channel.ChannelImp;
import org.fisco.bcos.sdk.channel.PeerSelectRule;
import org.fisco.bcos.sdk.channel.ResponseCallback;
import org.fisco.bcos.sdk.channel.model.Options;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.model.Response;
import org.fisco.bcos.sdk.network.ConnectionInfo;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.network.Network;

public interface Channel {
    public static Channel build(ConfigOption configOption) throws ConfigException {
        return new ChannelImp(configOption);
    }

    public Network getNetwork();

    public void start();

    public void stop();

    public void addMessageHandler(MsgType var1, MsgHandler var2);

    public void addConnectHandler(MsgHandler var1);

    public void addEstablishHandler(MsgHandler var1);

    public void addDisconnectHandler(MsgHandler var1);

    public void broadcastToGroup(Message var1, String var2);

    public void broadcast(Message var1);

    public Response sendToPeer(Message var1, String var2);

    public Response sendToPeerWithTimeOut(Message var1, String var2, Options var3);

    public Response sendToRandomWithTimeOut(Message var1, Options var2);

    public Response sendToPeerByRuleWithTimeOut(Message var1, PeerSelectRule var2, Options var3);

    public void asyncSendToPeer(Message var1, String var2, ResponseCallback var3, Options var4);

    public void asyncSendToRandom(Message var1, ResponseCallback var2, Options var3);

    public void asyncSendToPeerByRule(Message var1, PeerSelectRule var2, ResponseCallback var3, Options var4);

    public List<ConnectionInfo> getConnectionInfo();

    public List<String> getAvailablePeer();

    public void setThreadPool(ExecutorService var1);
}

