/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.client.ClientImpl;
import org.fisco.bcos.sdk.client.RespCallback;
import org.fisco.bcos.sdk.client.protocol.request.Transaction;
import org.fisco.bcos.sdk.client.protocol.response.AddPeers;
import org.fisco.bcos.sdk.client.protocol.response.BcosBlock;
import org.fisco.bcos.sdk.client.protocol.response.BcosBlockHeader;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransaction;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransactionReceipt;
import org.fisco.bcos.sdk.client.protocol.response.BcosTransactionReceiptsDecoder;
import org.fisco.bcos.sdk.client.protocol.response.BlockHash;
import org.fisco.bcos.sdk.client.protocol.response.BlockNumber;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.client.protocol.response.Code;
import org.fisco.bcos.sdk.client.protocol.response.ConsensusStatus;
import org.fisco.bcos.sdk.client.protocol.response.ErasePeers;
import org.fisco.bcos.sdk.client.protocol.response.GenerateGroup;
import org.fisco.bcos.sdk.client.protocol.response.GroupList;
import org.fisco.bcos.sdk.client.protocol.response.GroupPeers;
import org.fisco.bcos.sdk.client.protocol.response.NodeIDList;
import org.fisco.bcos.sdk.client.protocol.response.NodeInfo;
import org.fisco.bcos.sdk.client.protocol.response.ObserverList;
import org.fisco.bcos.sdk.client.protocol.response.PbftView;
import org.fisco.bcos.sdk.client.protocol.response.Peers;
import org.fisco.bcos.sdk.client.protocol.response.PendingTransactions;
import org.fisco.bcos.sdk.client.protocol.response.PendingTxSize;
import org.fisco.bcos.sdk.client.protocol.response.QueryGroupStatus;
import org.fisco.bcos.sdk.client.protocol.response.QueryPeers;
import org.fisco.bcos.sdk.client.protocol.response.RecoverGroup;
import org.fisco.bcos.sdk.client.protocol.response.RemoveGroup;
import org.fisco.bcos.sdk.client.protocol.response.SealerList;
import org.fisco.bcos.sdk.client.protocol.response.SendTransaction;
import org.fisco.bcos.sdk.client.protocol.response.StartGroup;
import org.fisco.bcos.sdk.client.protocol.response.StopGroup;
import org.fisco.bcos.sdk.client.protocol.response.SyncStatus;
import org.fisco.bcos.sdk.client.protocol.response.SystemConfig;
import org.fisco.bcos.sdk.client.protocol.response.TotalTransactionCount;
import org.fisco.bcos.sdk.client.protocol.response.TransactionReceiptWithProof;
import org.fisco.bcos.sdk.client.protocol.response.TransactionWithProof;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.eventsub.EventResource;
import org.fisco.bcos.sdk.model.NodeVersion;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.service.GroupManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Client {
    public static final Logger logger = LoggerFactory.getLogger(Client.class);

    public static Client build(GroupManagerService groupManagerService, Channel channel, EventResource eventResource, Integer groupId) {
        groupManagerService.fetchGroupList();
        groupManagerService.updateNodeVersion();
        Set<String> nodeList = groupManagerService.getGroupNodeList(groupId);
        if (nodeList == null || nodeList.size() == 0) {
            logger.warn("build client failed for no peers setup the group {}", (Object)groupId);
            return null;
        }
        Integer cryptoType = null;
        NodeVersion nodeVersion = null;
        for (String node : nodeList) {
            cryptoType = groupManagerService.getCryptoType(node);
            if (cryptoType == null) continue;
            nodeVersion = groupManagerService.getNodeVersion(node);
            break;
        }
        if (cryptoType == null || nodeVersion == null) {
            logger.warn("build client failed for get crypto type or nodeVersion failed, groupId: {}", (Object)groupId);
            return null;
        }
        CryptoSuite cryptoSuite = new CryptoSuite((int)cryptoType, groupManagerService.getConfig());
        logger.info("build client success for group {}, crypto type {}", (Object)groupId, (Object)cryptoType);
        return new ClientImpl(groupManagerService, channel, groupId, cryptoSuite, nodeVersion, eventResource);
    }

    public static Client build(Channel channel) {
        return new ClientImpl(channel);
    }

    public GroupManagerService getGroupManagerService();

    public CryptoSuite getCryptoSuite();

    public NodeVersion getClientNodeVersion();

    public Integer getCryptoType();

    public Integer getGroupId();

    public String getExtraData();

    public void setExtraData(String var1);

    public SendTransaction sendRawTransaction(String var1);

    public void sendRawTransactionAsync(String var1, RespCallback<SendTransaction> var2);

    public SendTransaction sendRawTransactionAndGetProof(String var1);

    public void sendRawTransactionAndGetProofAsync(String var1, RespCallback<SendTransaction> var2);

    public TransactionReceipt sendRawTransactionAndGetReceipt(String var1);

    public void sendRawTransactionAndGetReceiptAsync(String var1, TransactionCallback var2);

    public TransactionReceipt sendRawTransactionAndGetReceiptWithProof(String var1);

    public void sendRawTransactionAndGetReceiptWithProofAsync(String var1, TransactionCallback var2);

    public Call call(Transaction var1);

    public void callAsync(Transaction var1, RespCallback<Call> var2);

    public BlockNumber getBlockNumber();

    public BlockNumber getBlockNumber(Integer var1, String var2);

    public void getBlockNumberAsync(RespCallback<BlockNumber> var1);

    public Code getCode(String var1);

    public void getCodeAsync(String var1, RespCallback<Code> var2);

    public TotalTransactionCount getTotalTransactionCount();

    public void getTotalTransactionCountAsync(RespCallback<TotalTransactionCount> var1);

    public BcosBlock getBlockByHash(String var1, boolean var2);

    public void getBlockByHashAsync(String var1, boolean var2, RespCallback<BcosBlock> var3);

    public BcosBlock getBlockByNumber(BigInteger var1, boolean var2);

    public void getBlockByNumberAsync(BigInteger var1, boolean var2, RespCallback<BcosBlock> var3);

    public BlockHash getBlockHashByNumber(BigInteger var1);

    public void getBlockHashByNumberAsync(BigInteger var1, RespCallback<BlockHash> var2);

    public BcosBlockHeader getBlockHeaderByHash(String var1, boolean var2);

    public void getBlockHeaderByHashAsync(String var1, boolean var2, RespCallback<BcosBlockHeader> var3);

    public BcosBlockHeader getBlockHeaderByNumber(BigInteger var1, boolean var2);

    public void getBlockHeaderByNumberAsync(BigInteger var1, boolean var2, RespCallback<BcosBlockHeader> var3);

    public BcosTransaction getTransactionByHash(String var1);

    public void getTransactionByHashAsync(String var1, RespCallback<BcosTransaction> var2);

    public TransactionWithProof getTransactionByHashWithProof(String var1);

    public void getTransactionByHashWithProofAsync(String var1, RespCallback<TransactionWithProof> var2);

    public BcosTransaction getTransactionByBlockNumberAndIndex(BigInteger var1, BigInteger var2);

    public void getTransactionByBlockNumberAndIndexAsync(BigInteger var1, BigInteger var2, RespCallback<BcosTransaction> var3);

    public BcosTransaction getTransactionByBlockHashAndIndex(String var1, BigInteger var2);

    public void getTransactionByBlockHashAndIndexAsync(String var1, BigInteger var2, RespCallback<BcosTransaction> var3);

    public BcosTransactionReceipt getTransactionReceipt(String var1);

    public void getTransactionReceiptAsync(String var1, RespCallback<BcosTransactionReceipt> var2);

    public TransactionReceiptWithProof getTransactionReceiptByHashWithProof(String var1);

    public void getTransactionReceiptByHashWithProofAsync(String var1, RespCallback<TransactionReceiptWithProof> var2);

    public PendingTransactions getPendingTransaction();

    public void getPendingTransactionAsync(RespCallback<PendingTransactions> var1);

    public PendingTxSize getPendingTxSize();

    public void getPendingTxSizeAsync(RespCallback<PendingTxSize> var1);

    public BigInteger getBlockLimit();

    public GenerateGroup generateGroup(Integer var1, long var2, boolean var4, List<String> var5, String var6);

    public void generateGroupAsync(Integer var1, long var2, boolean var4, List<String> var5, String var6, RespCallback<GenerateGroup> var7);

    public StartGroup startGroup(Integer var1, String var2);

    public void startGroupAsync(Integer var1, String var2, RespCallback<StartGroup> var3);

    public StopGroup stopGroup(Integer var1, String var2);

    public void stopGroupAsync(Integer var1, String var2, RespCallback<StopGroup> var3);

    public RemoveGroup removeGroup(Integer var1, String var2);

    public void removeGroupAsync(Integer var1, String var2, RespCallback<RemoveGroup> var3);

    public RecoverGroup recoverGroup(Integer var1, String var2);

    public void recoverGroupAsync(Integer var1, String var2, RespCallback<RecoverGroup> var3);

    public QueryGroupStatus queryGroupStatus(Integer var1);

    public QueryGroupStatus queryGroupStatus(Integer var1, String var2);

    public void queryGroupStatusAsync(Integer var1, RespCallback<QueryGroupStatus> var2);

    public void queryGroupStatusAsync(Integer var1, String var2, RespCallback<QueryGroupStatus> var3);

    public GroupList getGroupList();

    public GroupList getGroupList(String var1);

    public void getGroupListAsync(RespCallback<GroupList> var1);

    public void getGroupListAsync(String var1, RespCallback<GroupList> var2);

    public GroupPeers getGroupPeers();

    public GroupPeers getGroupPeers(String var1);

    public void getGroupPeersAsync(RespCallback<GroupPeers> var1);

    public void getGroupPeersAsync(String var1, RespCallback<GroupPeers> var2);

    public Peers getPeers();

    public Peers getPeers(String var1);

    public void getPeersAsync(RespCallback<Peers> var1);

    public QueryPeers queryPeers(String var1);

    public ErasePeers erasePeers(String var1, List<String> var2);

    public AddPeers addPeers(String var1, List<String> var2);

    public NodeInfo getNodeInfo(String var1);

    public void getNodeInfoAsync(String var1, RespCallback<NodeInfo> var2);

    public NodeIDList getNodeIDList();

    public NodeIDList getNodeIDList(String var1);

    public void getNodeIDListAsync(RespCallback<NodeIDList> var1);

    public ObserverList getObserverList();

    public void getObserverList(RespCallback<ObserverList> var1);

    public SealerList getSealerList();

    public void getSealerListAsync(RespCallback<SealerList> var1);

    public PbftView getPbftView();

    public void getPbftViewAsync(RespCallback<PbftView> var1);

    public NodeVersion getNodeVersion(String var1);

    public NodeVersion getNodeVersion();

    public void getNodeVersion(RespCallback<NodeVersion> var1);

    public BcosTransactionReceiptsDecoder getBatchReceiptsByBlockNumberAndRange(BigInteger var1, String var2, String var3);

    public BcosTransactionReceiptsDecoder getBatchReceiptsByBlockHashAndRange(String var1, String var2, String var3);

    public ConsensusStatus getConsensusStatus();

    public void getConsensusStates(RespCallback<ConsensusStatus> var1);

    public SystemConfig getSystemConfigByKey(String var1);

    public SystemConfig getSystemConfigByKey(String var1, String var2);

    public void getSystemConfigByKeyAsync(String var1, RespCallback<SystemConfig> var2);

    public void getSystemConfigByKeyAsync(String var1, String var2, RespCallback<SystemConfig> var3);

    public SyncStatus getSyncStatus();

    public void getSyncStatus(RespCallback<SyncStatus> var1);

    public EventResource getEventResource();

    public void stop();
}

