/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.function.Consumer;
import org.fisco.bcos.sdk.channel.ChannelVersionNegotiation;
import org.fisco.bcos.sdk.channel.model.ChannelProtocol;
import org.fisco.bcos.sdk.channel.model.EnumChannelProtocolVersion;
import org.fisco.bcos.sdk.channel.model.EnumSocketChannelAttributeKey;
import org.fisco.bcos.sdk.client.handler.OnReceiveBlockNotifyFunc;
import org.fisco.bcos.sdk.model.AmopMsg;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockNumberNotifyHandler
implements MsgHandler {
    private static Logger logger = LoggerFactory.getLogger(BlockNumberNotifyHandler.class);
    private final OnReceiveBlockNotifyFunc blockNumberUpdater;
    private final Consumer<String> disconnectHandler;

    public BlockNumberNotifyHandler(OnReceiveBlockNotifyFunc blockNumberUpdater, Consumer<String> disconnectHandler) {
        this.blockNumberUpdater = blockNumberUpdater;
        this.disconnectHandler = disconnectHandler;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        logger.debug("set BlockNumberNotifyHandler");
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
        if (msg.getType().shortValue() != MsgType.BLOCK_NOTIFY.getType()) {
            return;
        }
        ChannelProtocol protocol = null;
        if (ctx.channel().attr(AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey())) != null && ctx.channel().attr(AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey())).get() != null) {
            protocol = (ChannelProtocol)ctx.channel().attr(AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey())).get();
        }
        EnumChannelProtocolVersion channelProtocolVersion = EnumChannelProtocolVersion.VERSION_1;
        if (protocol != null) {
            channelProtocolVersion = protocol.getEnumProtocol();
        }
        String peerIpAndPort = ChannelVersionNegotiation.getPeerHost(ctx);
        AmopMsg amopMsg = new AmopMsg(msg);
        amopMsg.decodeAmopBody(msg.getData());
        this.blockNumberUpdater.OnReceiveBlockNotify(channelProtocolVersion, peerIpAndPort, amopMsg);
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
        String peerIpAndPort = ChannelVersionNegotiation.getPeerHost(ctx);
        if (this.disconnectHandler != null) {
            this.disconnectHandler.accept(peerIpAndPort);
        }
        logger.debug("onDisconnect, endpoint: {}", (Object)peerIpAndPort);
    }
}

