/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.permission;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.precompiled.model.PrecompiledVersionCheck;
import org.fisco.bcos.sdk.contract.precompiled.permission.ChainGovernancePrecompiled;
import org.fisco.bcos.sdk.contract.precompiled.permission.PermissionInfo;
import org.fisco.bcos.sdk.contract.precompiled.permission.PermissionService;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;

public class ChainGovernanceService {
    private final ChainGovernancePrecompiled chainGovernancePrecompiled;
    private String currentVersion;

    public ChainGovernanceService(Client client, CryptoKeyPair credential) {
        this.chainGovernancePrecompiled = ChainGovernancePrecompiled.load("0x0000000000000000000000000000000000001008", client, credential);
        this.currentVersion = client.getClientNodeVersion().getNodeVersion().getSupportedVersion();
    }

    public RetCode grantCommitteeMember(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.grantCommitteeMember(userAddress));
    }

    public RetCode revokeCommitteeMember(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.revokeCommitteeMember(userAddress));
    }

    public List<PermissionInfo> listCommitteeMembers() throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            return PermissionService.parsePermissionInfo(this.chainGovernancePrecompiled.listCommitteeMembers());
        }
        catch (JsonProcessingException e) {
            throw new ContractException("listCommitteeMembers exceptioned, error info: " + e.getMessage(), e);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public RetCode updateCommitteeMemberWeight(String userAddress, BigInteger weight) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.updateCommitteeMemberWeight(userAddress, weight));
    }

    public RetCode updateThreshold(BigInteger threshold) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.updateThreshold(threshold));
    }

    public BigInteger queryThreshold() throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            return this.chainGovernancePrecompiled.queryThreshold();
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public BigInteger queryCommitteeMemberWeight(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            Tuple2<Boolean, BigInteger> queryResult = this.chainGovernancePrecompiled.queryCommitteeMemberWeight(userAddress);
            if (queryResult.getValue1().booleanValue()) {
                return queryResult.getValue2();
            }
            RetCode errorMessage = PrecompiledRetCode.getPrecompiledResponse(queryResult.getValue2().intValue(), queryResult.getValue2().toString());
            throw new ContractException("queryCommitteeMemberWeight failed, error info: " + errorMessage.getMessage(), errorMessage.getCode());
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public RetCode grantOperator(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.grantOperator(userAddress));
    }

    public RetCode revokeOperator(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.revokeOperator(userAddress));
    }

    public List<PermissionInfo> listOperators() throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            return PermissionService.parsePermissionInfo(this.chainGovernancePrecompiled.listOperators());
        }
        catch (JsonProcessingException e) {
            throw new ContractException("listOperators exceptioned, error info:" + e.getMessage(), e);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public RetCode freezeAccount(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.freezeAccount(userAddress));
    }

    public RetCode unfreezeAccount(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.chainGovernancePrecompiled.unfreezeAccount(userAddress));
    }

    public String getAccountStatus(String userAddress) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            return this.chainGovernancePrecompiled.getAccountStatus(userAddress);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public String queryVotesOfMember(String account) throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_QUERY_VERSION.checkVersion(this.currentVersion);
        try {
            return this.chainGovernancePrecompiled.queryVotesOfMember(account);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public String queryVotesOfThreshold() throws ContractException {
        PrecompiledVersionCheck.CHAIN_GOVERNANCE_PRECOMPILED_QUERY_VERSION.checkVersion(this.currentVersion);
        try {
            return this.chainGovernancePrecompiled.queryVotesOfThreshold();
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }
}

