/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.codec.decode;

import java.math.BigInteger;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.model.PrecompiledRetCode;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.TransactionReceiptStatus;
import org.fisco.bcos.sdk.transaction.codec.decode.RevertMessageParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptParser {
    private static final Logger logger = LoggerFactory.getLogger(ReceiptParser.class);

    private ReceiptParser() {
    }

    public static RetCode parseTransactionReceipt(TransactionReceipt receipt) throws ContractException {
        RetCode retCode = new RetCode();
        try {
            String status = receipt.getStatus();
            if (!"0x0".equals(status)) {
                retCode = TransactionReceiptStatus.getStatusMessage(status, receipt.getMessage());
                Tuple2<Boolean, String> errorOutput = RevertMessageParser.tryResolveRevertMessage(receipt);
                if (errorOutput.getValue1().booleanValue()) {
                    throw new ContractException(errorOutput.getValue2(), retCode.getCode(), receipt);
                }
                throw new ContractException(retCode.getMessage(), retCode.getCode(), receipt);
            }
            String output = receipt.getOutput();
            if (output.equals("0x")) {
                return PrecompiledRetCode.CODE_SUCCESS;
            }
            try {
                int statusValue = new BigInteger(output.substring(2, output.length()), 16).intValue();
                if (receipt.getMessage() == null || receipt.getMessage().equals("")) {
                    receipt.setMessage(PrecompiledRetCode.CODE_SUCCESS.getMessage());
                }
                retCode = PrecompiledRetCode.getPrecompiledResponse(statusValue, receipt.getMessage());
                retCode.setTransactionReceipt(receipt);
                return retCode;
            }
            catch (Exception e) {
                logger.debug("try to parse the output failed, output: {}, status: {}, exception: {}", new Object[]{output, receipt.getStatus(), e.getMessage()});
                retCode = PrecompiledRetCode.CODE_SUCCESS;
                retCode.setTransactionReceipt(receipt);
                return retCode;
            }
        }
        catch (NumberFormatException e) {
            throw new ContractException("NumberFormatException when parse receipt, receipt info: " + receipt.toString() + ", error info: " + e.getMessage());
        }
    }

    public static ContractException parseExceptionCall(ContractException exception) {
        Call.CallOutput callResult = exception.getResponseOutput();
        if (callResult == null) {
            return new ContractException(exception.getMessage(), exception);
        }
        RetCode retCode = ReceiptParser.parseCallOutput(callResult, exception.getMessage());
        return new ContractException(retCode.getMessage(), retCode.getCode());
    }

    public static RetCode parseCallOutput(Call.CallOutput callResult, String message) {
        if (!callResult.getStatus().equals("0x0")) {
            Tuple2<Boolean, String> errorOutput = RevertMessageParser.tryResolveRevertMessage(callResult.getStatus(), callResult.getOutput());
            if (errorOutput.getValue1().booleanValue()) {
                return new RetCode(Numeric.decodeQuantity(callResult.getStatus()).intValue(), errorOutput.getValue2());
            }
            return TransactionReceiptStatus.getStatusMessage(callResult.getStatus(), message);
        }
        try {
            if (callResult.getOutput().equals("0x")) {
                return PrecompiledRetCode.CODE_SUCCESS;
            }
            int statusValue = new BigInteger(callResult.getOutput().substring(2, callResult.getOutput().length()), 16).intValue();
            RetCode ret = PrecompiledRetCode.getPrecompiledResponse(statusValue, PrecompiledRetCode.CODE_SUCCESS.getMessage());
            return new RetCode(ret.getCode(), ret.getMessage());
        }
        catch (Exception e) {
            return PrecompiledRetCode.CODE_SUCCESS;
        }
    }
}

