/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.rlp.RlpEncoder;
import org.fisco.bcos.web3j.rlp.RlpList;
import org.fisco.bcos.web3j.rlp.RlpString;
import org.fisco.bcos.web3j.rlp.RlpType;
import org.fisco.bcos.web3j.utils.Numeric;

public class ReceiptEncoder {
    public static String encode(TransactionReceipt transactionReceipt) {
        List<RlpType> values = ReceiptEncoder.asRlpValues(transactionReceipt);
        RlpList rlpList = new RlpList(values);
        byte[] rlpBytes = RlpEncoder.encode(rlpList);
        return Numeric.toHexString(rlpBytes);
    }

    private static List<RlpType> asRlpValues(TransactionReceipt transactionReceipt) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add(RlpString.create(Numeric.hexStringToByteArray(transactionReceipt.getRoot())));
        result.add(RlpString.create(Numeric.toBigInt(transactionReceipt.getGasUsedRaw())));
        result.add(RlpString.create(Numeric.hexStringToByteArray(transactionReceipt.getContractAddress())));
        result.add(RlpString.create(Numeric.hexStringToByteArray(transactionReceipt.getLogsBloom())));
        result.add(RlpString.create(Numeric.toBigInt(transactionReceipt.getStatus())));
        result.add(RlpString.create(Numeric.hexStringToByteArray(transactionReceipt.getOutput())));
        List<Log> logs = transactionReceipt.getLogs();
        ArrayList<RlpType> logList = new ArrayList<RlpType>();
        for (Log log : logs) {
            ArrayList<RlpType> logUnit = new ArrayList<RlpType>();
            logUnit.add(RlpString.create(Numeric.hexStringToByteArray(log.getAddress())));
            List<String> topics = log.getTopics();
            ArrayList<RlpType> topicList = new ArrayList<RlpType>();
            for (String topic : topics) {
                topicList.add(RlpString.create(Numeric.hexStringToByteArray(topic)));
            }
            RlpList topicRlpList = new RlpList(topicList);
            logUnit.add(topicRlpList);
            logUnit.add(RlpString.create(Numeric.hexStringToByteArray(log.getData())));
            logList.add(new RlpList(logUnit));
        }
        RlpList logRlpList = new RlpList(logList);
        result.add(logRlpList);
        return result;
    }
}

