/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.tool;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.fisco.bcos.web3j.crypto.tool.ECCParams;
import org.fisco.bcos.web3j.utils.Numeric;

public class ECCEncrypt {
    private final BigInteger pubKey;
    private final BCECPublicKey bCECPublicKey;

    public ECCEncrypt(BigInteger pubKey) {
        this.pubKey = pubKey;
        this.bCECPublicKey = this.createBCECPublicKey(pubKey);
    }

    public BigInteger getPubKey() {
        return this.pubKey;
    }

    public BCECPublicKey getbCECPublicKey() {
        return this.bCECPublicKey;
    }

    private BCECPublicKey createBCECPublicKey(BigInteger publicKey) {
        String publicKeyValue = Numeric.toHexStringNoPrefixZeroPadded(publicKey, 128);
        String prePublicKeyStr = publicKeyValue.substring(0, 64);
        String postPublicKeyStr = publicKeyValue.substring(64);
        SecP256K1Curve secP256K1Curve = new SecP256K1Curve();
        SecP256K1Point secP256K1Point = (SecP256K1Point)secP256K1Curve.createPoint(new BigInteger(prePublicKeyStr, 16), new BigInteger(postPublicKeyStr, 16));
        SecP256K1Point secP256K1PointG = (SecP256K1Point)secP256K1Curve.createPoint(ECCParams.POINTG_PRE, ECCParams.POINTG_POST);
        ECDomainParameters domainParameters = new ECDomainParameters((ECCurve)secP256K1Curve, (ECPoint)secP256K1PointG, ECCParams.FACTOR_N);
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters((ECPoint)secP256K1Point, domainParameters);
        BCECPublicKey bcecPublicKey = new BCECPublicKey("ECDSA", publicKeyParameters, (ECParameterSpec)ECCParams.ecNamedCurveSpec, BouncyCastleProvider.CONFIGURATION);
        return bcecPublicKey;
    }

    public byte[] encrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(" ECIES", "BC");
        cipher.init(1, (Key)this.getbCECPublicKey(), (AlgorithmParameterSpec)ECCParams.IES_PARAMS);
        return cipher.doFinal(data);
    }
}

