/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.permission;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.permission.ChainGovernance;
import org.fisco.bcos.web3j.precompile.permission.PermissionInfo;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class ChainGovernanceService {
    private static BigInteger gasPrice = new BigInteger("30000000000");
    private static BigInteger gasLimit = new BigInteger("30000000000");
    private static final String chainGovernanceAddress = "0x0000000000000000000000000000000000001008";
    private ChainGovernance chainGovernance;
    private Web3j web3j;

    public static String getChainGovernanceAddress() {
        return chainGovernanceAddress;
    }

    public ChainGovernance getChainGovernance() {
        return this.chainGovernance;
    }

    public void setChainGovernance(ChainGovernance chainGovernance) {
        this.chainGovernance = chainGovernance;
    }

    public ChainGovernanceService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.chainGovernance = ChainGovernance.load(chainGovernanceAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
        this.web3j = web3j;
    }

    public List<PermissionInfo> listOperators() throws Exception {
        String operatorsInfo = this.chainGovernance.listOperators().send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(operatorsInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }

    public String updateCommitteeMemberWeight(String account, int weight) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.updateCommitteeMemberWeight(account, BigInteger.valueOf(weight)).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public BigInteger queryThreshold() throws Exception {
        return this.chainGovernance.queryThreshold().send();
    }

    public Tuple2<Boolean, BigInteger> queryCommitteeMemberWeight(String account) throws Exception {
        return this.chainGovernance.queryCommitteeMemberWeight(account).send();
    }

    public String grantCommitteeMember(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.grantCommitteeMember(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public List<PermissionInfo> listCommitteeMembers() throws Exception {
        String committeeMembersInfo = this.chainGovernance.listCommitteeMembers().send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(committeeMembersInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }

    public String updateThreshold(int threshold) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.updateThreshold(BigInteger.valueOf(threshold)).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String revokeCommitteeMember(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.revokeCommitteeMember(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String grantOperator(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.grantOperator(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String revokeOperator(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.revokeOperator(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String freezeAccount(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.freezeAccount(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String unfreezeAccount(String account) throws Exception {
        TransactionReceipt transactionReceipt = this.chainGovernance.unfreezeAccount(account).send();
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public String getAccountStatus(String account) throws Exception {
        return this.chainGovernance.getAccountStatus(account).send();
    }
}

