/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.ExtendedRawTransaction;
import org.fisco.bcos.web3j.crypto.ExtendedTransactionEncoder;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.exceptions.TxHashMismatchException;
import org.fisco.bcos.web3j.utils.Numeric;
import org.fisco.bcos.web3j.utils.TxHashVerifier;

public class ExtendedRawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    @Deprecated
    private final byte chainId;
    private final BigInteger groupId;
    private final BigInteger fiscoChainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    @Deprecated
    public Web3j getWeb3j() {
        return this.web3j;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ExtendedRawTransactionManager(Web3j web3j, Credentials credentials, byte chainId, BigInteger groupId, BigInteger fiscoChainId) {
        super(web3j, credentials);
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
        this.groupId = groupId;
        this.fiscoChainId = fiscoChainId;
    }

    @Deprecated
    public ExtendedRawTransactionManager(Web3j web3j, Credentials credentials, byte chainId, int attempts, int sleepDuration, BigInteger groupId, BigInteger fiscoChainId) {
        super(web3j, attempts, sleepDuration, credentials);
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
        this.groupId = groupId;
        this.fiscoChainId = fiscoChainId;
    }

    public ExtendedRawTransactionManager(Web3j web3j, Credentials credentials, BigInteger groupId, BigInteger fiscoChainId) {
        super(web3j, credentials);
        this.web3j = web3j;
        this.credentials = credentials;
        this.groupId = groupId;
        this.fiscoChainId = fiscoChainId;
        this.chainId = (byte)-1;
    }

    @Deprecated
    public ExtendedRawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration, BigInteger groupId, BigInteger fiscoChainId) {
        this(web3j, credentials, -1, attempts, sleepDuration, groupId, fiscoChainId);
    }

    @Override
    protected BigInteger getBlockLimit() throws IOException {
        return this.web3j.getBlockNumberCache();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public ExtendedRawTransaction createTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData) throws IOException {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BigInteger randomid = new BigInteger(250, r);
        BigInteger blockLimit = this.getBlockLimit();
        ExtendedRawTransaction rawTransaction = ExtendedRawTransaction.createTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data, this.fiscoChainId, this.groupId, extraData);
        return rawTransaction;
    }

    @Override
    public SendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData) throws IOException {
        ExtendedRawTransaction rawTransaction = this.createTransaction(gasPrice, gasLimit, to, data, value, extraData);
        return this.signAndSend(rawTransaction);
    }

    @Override
    public SendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, String extraData, TransactionSucCallback callback) throws IOException {
        ExtendedRawTransaction rawTransaction = this.createTransaction(gasPrice, gasLimit, to, data, value, extraData);
        return this.signAndSend(rawTransaction, callback);
    }

    @Override
    public SendTransaction sendTransaction(String signedTransaction) throws IOException, TxHashMismatchException {
        String txHashRemote;
        String txHashLocal;
        SendTransaction sendTransaction = this.web3j.sendRawTransaction(signedTransaction).send();
        if (sendTransaction != null && !sendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3(signedTransaction), txHashRemote = sendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return sendTransaction;
    }

    @Override
    public SendTransaction sendTransaction(String signedTransaction, TransactionSucCallback callback) throws IOException, TxHashMismatchException {
        Request<?, SendTransaction> request = this.web3j.sendRawTransaction(signedTransaction);
        request.setNeedTransCallback(true);
        request.setTransactionSucCallback(callback);
        request.sendOnly();
        return null;
    }

    @Override
    public String sign(ExtendedRawTransaction rawTransaction) {
        byte[] signedMessage = this.chainId > -1 ? ExtendedTransactionEncoder.signMessage(rawTransaction, this.chainId, this.credentials) : ExtendedTransactionEncoder.signMessage(rawTransaction, this.credentials);
        String signedData = Numeric.toHexString(signedMessage);
        return signedData;
    }

    public SendTransaction signAndSend(ExtendedRawTransaction rawTransaction) throws IOException {
        String signedTransaction = this.sign(rawTransaction);
        SendTransaction result = this.sendTransaction(signedTransaction);
        return result;
    }

    public SendTransaction signAndSend(ExtendedRawTransaction rawTransaction, TransactionSucCallback callback) throws IOException {
        String signedTransaction = this.sign(rawTransaction);
        SendTransaction result = this.sendTransaction(signedTransaction, callback);
        return result;
    }
}

