/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.fisco.bcos.web3j.utils.Web3AsyncThreadPoolSize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async {
    static Logger logger = LoggerFactory.getLogger(Async.class);
    private static Executor executor;

    public static <T> CompletableFuture<T> run(Callable<T> callable) {
        if (null == executor) {
            logger.info(" default set setExeutor , pool size is {}", (Object)Web3AsyncThreadPoolSize.web3AsyncPoolSize);
            Async.setExeutor(Executors.newFixedThreadPool(Web3AsyncThreadPoolSize.web3AsyncPoolSize), true);
        }
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                result.complete(callable.call());
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
        }, executor);
        return result;
    }

    private static int getCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static ScheduledExecutorService defaultExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Async.getCpuCount());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Async.shutdown(scheduledExecutorService)));
        return scheduledExecutorService;
    }

    private static void shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static synchronized void setExeutor(Executor pool, boolean setIfNull) {
        if (null == executor && setIfNull) {
            executor = pool;
            logger.info(" set setExeutor because executor null, executor is {}", (Object)pool.toString());
        } else if (!setIfNull) {
            executor = pool;
            logger.info(" set setExeutor even executor already exist, executor is {}", (Object)pool.toString());
        }
    }

    public Async(Executor pool) {
        Async.setExeutor(pool, true);
    }
}

