/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fisco.bcos.channel.client.CallResult;
import org.fisco.bcos.channel.client.ExecuteTransaction;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.abi.FunctionEncoder;
import org.fisco.bcos.web3j.abi.FunctionReturnDecoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.Utils;
import org.fisco.bcos.web3j.abi.datatypes.DynamicArray;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.StaticArray;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.abi.datatypes.Utf8String;
import org.fisco.bcos.web3j.abi.datatypes.generated.Int256;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.channel.StatusCode;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterName;
import org.fisco.bcos.web3j.protocol.core.methods.request.Transaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.Call;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;

public class CallContract {
    private static final BigInteger gasPrice = new BigInteger("3000000000");
    private static final BigInteger gasLimit = new BigInteger("3000000000");
    private Credentials credentials;
    private Web3j web3j;

    public CallContract(Credentials credentials, Web3j web3j) {
        this.credentials = credentials;
        this.web3j = web3j;
    }

    public CallResult call(String contractAddress, String funcName, Type ... args) {
        Call ethCall;
        Function function = new Function(funcName, Arrays.asList(args), Collections.emptyList());
        String data = FunctionEncoder.encode(function);
        try {
            ethCall = this.web3j.call(Transaction.createEthCallTransaction(this.credentials.getAddress(), contractAddress, data), DefaultBlockParameterName.LATEST).send();
        }
        catch (Exception e) {
            return new CallResult("0x30", e.getMessage(), "0x");
        }
        Call.CallOutput callOutput = ethCall.getValue();
        if (callOutput != null) {
            return new CallResult(callOutput.getStatus(), StatusCode.getStatusMessage(callOutput.getStatus()), callOutput.getOutput());
        }
        return new CallResult("0x31", StatusCode.getStatusMessage("0x31"), "0x");
    }

    public TransactionReceipt sendTransaction(String contractAddress, String funcName, Type ... args) {
        Function function = new Function(funcName, Arrays.asList(args), Collections.emptyList());
        TransactionReceipt transactionReceipt = new TransactionReceipt();
        try {
            ExecuteTransaction executeTransaction = new ExecuteTransaction(contractAddress, this.web3j, this.credentials, gasPrice, gasLimit);
            transactionReceipt = executeTransaction.send(function);
            String status = transactionReceipt.getStatus();
            transactionReceipt.setMessage(StatusCode.getStatusMessage(status));
        }
        catch (Exception e) {
            transactionReceipt.setStatus("0x30");
            transactionReceipt.setMessage(e.getMessage());
            transactionReceipt.setOutput("0x");
        }
        return transactionReceipt;
    }

    public TransactionReceipt sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String contractAddress, String funcName, Type ... args) {
        Function function = new Function(funcName, Arrays.asList(args), Collections.emptyList());
        TransactionReceipt transactionReceipt = new TransactionReceipt();
        try {
            ExecuteTransaction executeTransaction = new ExecuteTransaction(contractAddress, this.web3j, this.credentials, gasPrice, gasLimit);
            transactionReceipt = executeTransaction.send(function);
            String status = transactionReceipt.getStatus();
            transactionReceipt.setMessage(StatusCode.getStatusMessage(status));
        }
        catch (Exception e) {
            transactionReceipt.setStatus("0x30");
            transactionReceipt.setMessage(e.getMessage());
            transactionReceipt.setOutput("0x");
        }
        return transactionReceipt;
    }

    public void asyncSendTransaction(TransactionSucCallback callback, String contractAddress, String funcName, Type ... args) {
        Function function = new Function(funcName, Arrays.asList(args), Collections.emptyList());
        ExecuteTransaction executeTransaction = new ExecuteTransaction(contractAddress, this.web3j, this.credentials, gasPrice, gasLimit);
        executeTransaction.asyncSend(function, callback);
    }

    public void asyncSendTransaction(TransactionSucCallback callback, BigInteger gasPrice, BigInteger gasLimit, String contractAddress, String funcName, Type ... args) {
        Function function = new Function(funcName, Arrays.asList(args), Collections.emptyList());
        ExecuteTransaction executeTransaction = new ExecuteTransaction(contractAddress, this.web3j, this.credentials, gasPrice, gasLimit);
        executeTransaction.asyncSend(function, callback);
    }

    public List<Type> decode(String data, TypeReference<?> ... typeReferences) {
        if (data.isEmpty() || data.equals("0x")) {
            return null;
        }
        List<TypeReference<?>> typeReferencesList = Arrays.asList(typeReferences);
        return FunctionReturnDecoder.decode(data, Utils.convert(typeReferencesList));
    }

    public List<Object> decode(String data, String retType) throws Exception {
        List<Object> result = new ArrayList<Object>();
        if (!retType.equals("") && data != null) {
            String[] types = retType.split(",");
            List<TypeReference<?>> references = this.getTypeReferenceList(types);
            List<Type> returns = FunctionReturnDecoder.decode(data, Utils.convert(references));
            result = this.types2Objects(returns, types);
        }
        return result;
    }

    private List<TypeReference<?>> getTypeReferenceList(String[] types) throws Exception {
        ArrayList result = new ArrayList();
        block12: for (String type : types) {
            switch (type.trim()) {
                case "Int": {
                    result.add(new TypeReference<Int256>(){});
                    continue block12;
                }
                case "String": {
                    result.add(new TypeReference<Utf8String>(){});
                    continue block12;
                }
                case "IntArray": {
                    result.add(new TypeReference<DynamicArray<Int256>>(){});
                    continue block12;
                }
                case "StringArray": {
                    result.add(new TypeReference<DynamicArray<Utf8String>>(){});
                    continue block12;
                }
                default: {
                    throw new Exception("Unsupported type :" + type.trim());
                }
            }
        }
        return result;
    }

    public List<Object> types2Objects(List<Type> datas, String[] javaTypes) throws Exception {
        if (datas.size() != javaTypes.length) {
            throw new Exception("The number of data and types is different.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < datas.size(); ++i) {
            result.add(this.type2Object(datas.get(i), javaTypes[i]));
        }
        return result;
    }

    public Object type2Object(Type data, String javaType) throws Exception {
        switch (javaType) {
            case "Int": {
                return ((BigInteger)data.getValue()).intValue();
            }
            case "String": {
                return (String)data.getValue();
            }
            case "IntArray": {
                List<BigInteger> bigIntegers = this.convertList((List)data.getValue());
                return this.bigIntegerstoIntegers(bigIntegers);
            }
            case "StringArray": {
                return this.convertList((List)data.getValue());
            }
        }
        throw new Exception("Unsupported type :" + javaType);
    }

    public List<Integer> bigIntegerstoIntegers(List<BigInteger> bigIntegers) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (BigInteger bigInteger : bigIntegers) {
            integers.add(bigInteger.intValue());
        }
        return integers;
    }

    public <S extends Type, T> List<T> convertList(List<S> arr) {
        ArrayList out = new ArrayList();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public <S extends Type, T> List<List<T>> convertListList(List<StaticArray<S>> arrs) {
        ArrayList<List<T>> out = new ArrayList<List<T>>();
        for (StaticArray<S> arr : arrs) {
            List<T> temp = this.convertList((List<S>)arr.getValue());
            out.add(temp);
        }
        return out;
    }
}

