/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.dto;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import org.fisco.bcos.channel.handler.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMessage2
extends Message {
    private static Logger logger = LoggerFactory.getLogger(ChannelMessage2.class);
    private static final long serialVersionUID = -7276897518418560354L;
    private String topic;

    public ChannelMessage2() {
    }

    public ChannelMessage2(Message msg) {
        this.length = msg.getLength();
        this.type = msg.getType();
        this.seq = msg.getSeq();
        this.result = msg.getResult();
    }

    @Override
    public void readExtra(ByteBuf in) {
        if (this.result == 0) {
            Short topicLength = in.readUnsignedByte();
            byte[] topicBytes = new byte[topicLength - 1];
            in.readBytes(topicBytes, 0, topicLength - 1);
            this.topic = new String(topicBytes);
            this.data = new byte[this.length - 42 - topicLength];
            in.readBytes(this.data, 0, this.length - 42 - topicLength);
        }
    }

    @Override
    public void writeHeader(ByteBuf out) {
        try {
            this.length = 43 + this.topic.getBytes("utf-8").length + this.data.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        super.writeHeader(out);
    }

    @Override
    public void writeExtra(ByteBuf out) {
        try {
            out.writeByte(1 + this.topic.getBytes("utf-8").length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        out.writeBytes(this.topic.getBytes());
        out.writeBytes(this.data);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String toTopic) {
        this.topic = toTopic;
    }
}

