/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.abi.wrapper;

import org.fisco.bcos.web3j.abi.wrapper.ABIDefinition;
import org.fisco.bcos.web3j.abi.wrapper.ContractABIDefinition;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABIDefinitionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ABIDefinitionFactory.class);

    public static ContractABIDefinition loadABI(String abi) {
        try {
            ABIDefinition[] abiDefinitions = (ABIDefinition[])ObjectMapperFactory.getObjectMapper().readValue(abi, ABIDefinition[].class);
            ContractABIDefinition contractABIDefinition = new ContractABIDefinition();
            for (ABIDefinition abiDefinition : abiDefinitions) {
                if (abiDefinition.getType().equals("constructor")) {
                    contractABIDefinition.setConstructor(abiDefinition);
                } else if (abiDefinition.getType().equals("function")) {
                    contractABIDefinition.addFunction(abiDefinition.getName(), abiDefinition);
                } else if (abiDefinition.getType().equals("event")) {
                    contractABIDefinition.addEvent(abiDefinition.getName(), abiDefinition);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(" abiDefinition: {}", (Object)abiDefinition);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" contractABIDefinition {} ", (Object)contractABIDefinition);
            }
            return contractABIDefinition;
        }
        catch (Exception e) {
            logger.error(" e: ", (Throwable)e);
            return null;
        }
    }
}

