/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.fisco.bcos.web3j.abi.datatypes.Bytes;
import org.fisco.bcos.web3j.abi.datatypes.Int;
import org.fisco.bcos.web3j.abi.datatypes.StaticArray;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.abi.datatypes.Uint;
import org.fisco.bcos.web3j.codegen.Generator;

public class AbiTypesGenerator
extends Generator {
    private static final String CODEGEN_WARNING = AbiTypesGenerator.buildWarning(AbiTypesGenerator.class);
    private static final String DEFAULT = "DEFAULT";

    public static void main(String[] args) throws Exception {
        AbiTypesGenerator abiTypesGenerator = new AbiTypesGenerator();
        if (args.length == 1) {
            abiTypesGenerator.generate(args[0]);
        } else {
            abiTypesGenerator.generate(System.getProperty("user.dir") + "/abi/src/main/java/");
        }
    }

    private void generate(String destinationDir) throws IOException {
        this.generateIntTypes(Int.class, destinationDir);
        this.generateIntTypes(Uint.class, destinationDir);
        this.generateBytesTypes(Bytes.class, destinationDir);
        this.generateStaticArrayTypes(StaticArray.class, destinationDir);
    }

    private <T extends Type> void generateIntTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int bitSize = 8; bitSize <= 256; bitSize += 8) {
            ClassName className = ClassName.get((String)packageName, (String)(superclass.getSimpleName() + bitSize), (String[])new String[0]);
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(BigInteger.class, "value", new Modifier[0]).addStatement("super($L, $N)", new Object[]{bitSize, "value"}).build();
            MethodSpec overideConstructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Long.TYPE, "value", new Modifier[0]).addStatement("this(BigInteger.valueOf(value))", new Object[0]).build();
            FieldSpec defaultFieldSpec = FieldSpec.builder((TypeName)className, (String)DEFAULT, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(BigInteger.ZERO)", new Object[]{className}).build();
            TypeSpec intType = TypeSpec.classBuilder((String)className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(superclass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(defaultFieldSpec).addMethods(Arrays.asList(constructorSpec, overideConstructorSpec)).build();
            this.write(packageName, intType, path);
        }
    }

    private <T extends Type> void generateFixedTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int mBitSize = 8; mBitSize < 256; mBitSize += 8) {
            for (int nBitSize = 8; nBitSize < 256 && mBitSize + nBitSize <= 256; nBitSize += 8) {
                MethodSpec constructorSpec1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(BigInteger.class, "value", new Modifier[0]).addStatement("super($L, $L, $N)", new Object[]{mBitSize, nBitSize, "value"}).build();
                MethodSpec constructorSpec2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "mBitSize", new Modifier[0]).addParameter(Integer.TYPE, "nBitSize", new Modifier[0]).addParameter(BigInteger.class, "m", new Modifier[0]).addParameter(BigInteger.class, "n", new Modifier[0]).addStatement("super($L, $L, $N, $N)", new Object[]{mBitSize, nBitSize, "m", "n"}).build();
                ClassName className = ClassName.get((String)packageName, (String)(superclass.getSimpleName() + mBitSize + "x" + nBitSize), (String[])new String[0]);
                FieldSpec defaultFieldSpec = FieldSpec.builder((TypeName)className, (String)DEFAULT, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(BigInteger.ZERO)", new Object[]{className}).build();
                TypeSpec fixedType = TypeSpec.classBuilder((String)className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(superclass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(defaultFieldSpec).addMethod(constructorSpec1).addMethod(constructorSpec2).build();
                this.write(packageName, fixedType, path);
            }
        }
    }

    private <T extends Type> void generateBytesTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int byteSize = 1; byteSize <= 32; ++byteSize) {
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(byte[].class, "value", new Modifier[0]).addStatement("super($L, $N)", new Object[]{byteSize, "value"}).build();
            ClassName className = ClassName.get((String)packageName, (String)(superclass.getSimpleName() + byteSize), (String[])new String[0]);
            FieldSpec defaultFieldSpec = FieldSpec.builder((TypeName)className, (String)DEFAULT, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(new byte[$L])", new Object[]{className, byteSize}).build();
            TypeSpec bytesType = TypeSpec.classBuilder((String)className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(superclass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(defaultFieldSpec).addMethod(constructorSpec).build();
            this.write(packageName, bytesType, path);
        }
    }

    private <T extends Type> void generateStaticArrayTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int length = 1; length <= StaticArray.MAX_SIZE_OF_STATIC_ARRAY; ++length) {
            TypeVariableName typeVariableName = TypeVariableName.get((String)"T").withBounds(new java.lang.reflect.Type[]{Type.class});
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{typeVariableName}), "values", new Modifier[0]).addStatement("super($L, $N)", new Object[]{length, "values"}).build();
            MethodSpec arrayOverloadConstructorSpec = MethodSpec.constructorBuilder().addAnnotation(SafeVarargs.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ArrayTypeName.of((TypeName)typeVariableName), "values", new Modifier[0]).varargs().addStatement("super($L, $N)", new Object[]{length, "values"}).build();
            ClassName className = ClassName.get((String)packageName, (String)(superclass.getSimpleName() + length), (String[])new String[0]);
            TypeSpec bytesType = TypeSpec.classBuilder((String)className.simpleName()).addTypeVariable(typeVariableName).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(superclass), (TypeName[])new TypeName[]{typeVariableName})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(Arrays.asList(constructorSpec, arrayOverloadConstructorSpec)).build();
            this.write(packageName, bytesType, path);
        }
    }

    static String createPackageName(Class<?> cls) {
        return AbiTypesGenerator.getPackageName(cls) + ".generated";
    }

    static String getPackageName(Class<?> cls) {
        return cls.getPackage().getName();
    }
}

