/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.fisco.bcos.web3j.codegen.Console;
import org.fisco.bcos.web3j.codegen.FunctionWrapperGenerator;
import org.fisco.bcos.web3j.codegen.SolidityFunctionWrapper;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.core.methods.response.AbiDefinition;
import org.fisco.bcos.web3j.utils.Collection;
import org.fisco.bcos.web3j.utils.Files;
import picocli.CommandLine;

public class SolidityFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    public static final String COMMAND_SOLIDITY = "solidity";
    public static final String COMMAND_GENERATE = "generate";
    public static final String COMMAND_PREFIX = "solidity generate";
    private final File binFile;
    private final File smBinFile;
    private final File abiFile;

    private SolidityFunctionWrapperGenerator(File binFile, File abiFile, File destinationDir, String basePackageName, boolean useJavaNativeTypes) {
        this(binFile, null, abiFile, destinationDir, basePackageName, useJavaNativeTypes);
    }

    private SolidityFunctionWrapperGenerator(File binFile, File smBinFile, File abiFile, File destinationDir, String basePackageName, boolean useJavaNativeTypes) {
        super(destinationDir, basePackageName, useJavaNativeTypes);
        this.binFile = binFile;
        this.smBinFile = smBinFile;
        this.abiFile = abiFile;
    }

    static List<AbiDefinition> loadContractDefinition(File absFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(absFile, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private void generate() throws IOException, ClassNotFoundException {
        byte[] bytes;
        String binary = "Bin file was not provided";
        String smBinary = "Bin file was not provided";
        if (this.binFile != null) {
            bytes = Files.readBytes(this.binFile);
            binary = new String(bytes);
        }
        if (this.smBinFile != null) {
            bytes = Files.readBytes(this.smBinFile);
            smBinary = new String(bytes);
        }
        bytes = Files.readBytes(this.abiFile);
        String abi = new String(bytes);
        List<AbiDefinition> functionDefinitions = SolidityFunctionWrapperGenerator.loadContractDefinition(this.abiFile);
        if (functionDefinitions.isEmpty()) {
            System.out.println("Unable to parse input ABI file and skip this abi: " + this.abiFile.getName());
            return;
        }
        String contractName = SolidityFunctionWrapperGenerator.getFileNameNoExtension(this.abiFile.getName());
        new SolidityFunctionWrapper(this.useJavaNativeTypes).generateJavaFiles(contractName, binary, smBinary, abi, this.destinationDirLocation.toString(), this.basePackageName);
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals(COMMAND_SOLIDITY)) {
            args = Collection.tail(args);
        }
        if (args.length > 0 && args[0].equals(COMMAND_GENERATE)) {
            args = Collection.tail(args);
        }
        CommandLine.run((Runnable)new PicocliRunner(), (String[])args);
    }

    @CommandLine.Command(name="solidity generate", mixinStandardHelpOptions=true, version={"4.0"}, sortOptions=false)
    static class PicocliRunner
    implements Runnable {
        @CommandLine.Option(names={"-a", "--abiFile"}, description={"abi file with contract definition."}, required=true)
        private File abiFile;
        @CommandLine.Option(names={"-b", "--binFile"}, description={"bin file with contract compiled code in order to generate deploy methods."}, required=false)
        private File binFile;
        @CommandLine.Option(names={"-s", "--smBinFile"}, description={"sm bin file with contract compiled code in order to generate deploy methods."}, required=false)
        private File smBinFile;
        @CommandLine.Option(names={"-o", "--outputDir"}, description={"destination base directory."}, required=true)
        private File destinationFileDir;
        @CommandLine.Option(names={"-p", "--package"}, description={"base package name."}, required=true)
        private String packageName;
        @CommandLine.Option(names={"-jt", "--javaTypes"}, description={"use native java types."}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private boolean javaTypes = true;
        @CommandLine.Option(names={"-st", "--solidityTypes"}, description={"use solidity types."}, required=false)
        private boolean solidityTypes;

        PicocliRunner() {
        }

        @Override
        public void run() {
            try {
                boolean useJavaTypes = !this.solidityTypes;
                new SolidityFunctionWrapperGenerator(this.binFile, this.smBinFile, this.abiFile, this.destinationFileDir, this.packageName, useJavaTypes).generate();
            }
            catch (Exception e) {
                Console.exitError(e);
            }
        }
    }
}

