/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.fisco.bcos.web3j.crypto.ECDSASignature;
import org.fisco.bcos.web3j.crypto.ECDSASigner;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.crypto.Sign;
import org.fisco.bcos.web3j.crypto.SignInterface;
import org.fisco.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSASign
implements SignInterface {
    private static final Logger logger = LoggerFactory.getLogger(ECDSASign.class);
    private static final BigInteger curveN = new BigInteger(1, Hex.decode((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"));
    private static final BigInteger halfCurveN = curveN.shiftRight(1);

    public Sign.SignatureData secp256SignMessage(byte[] message, ECKeyPair keyPair) {
        Sign.SignatureData signatureData = this.signMessage(message, keyPair);
        return new Sign.SignatureData((byte)(signatureData.getV() - 27), signatureData.getR(), signatureData.getS());
    }

    public boolean secp256Verify(byte[] hash, BigInteger publicKey, Sign.SignatureData signatureData) {
        return this.verify(hash, publicKey, new Sign.SignatureData((byte)(signatureData.getV() + 27), signatureData.getR(), signatureData.getS()));
    }

    @Override
    public Sign.SignatureData signMessage(byte[] message, ECKeyPair keyPair) {
        BigInteger privateKey = keyPair.getPrivateKey();
        BigInteger publicKey = keyPair.getPublicKey();
        byte[] messageHash = Hash.sha3(message);
        ECDSASignature sig = ECDSASign.sign(messageHash, privateKey);
        ECPoint ecPoint = sig.p;
        BigInteger affineXCoordValue = ecPoint.normalize().getAffineXCoord().toBigInteger();
        BigInteger affineYCoordValue = ecPoint.normalize().getAffineYCoord().toBigInteger();
        int recId = affineYCoordValue.and(BigInteger.ONE).intValue();
        recId |= affineXCoordValue.compareTo(sig.r) != 0 ? 2 : 0;
        if (sig.s.compareTo(halfCurveN) > 0) {
            sig.s = Sign.CURVE.getN().subtract(sig.s);
            recId ^= 1;
        }
        int headerByte = recId + 27;
        byte v = (byte)headerByte;
        byte[] r = Numeric.toBytesPadded(sig.r, 32);
        byte[] s = Numeric.toBytesPadded(sig.s, 32);
        return new Sign.SignatureData(v, r, s);
    }

    public boolean verify(byte[] hash, BigInteger publicKey, Sign.SignatureData signatureData) {
        ECDSASignature sig = new ECDSASignature(Numeric.toBigInt(signatureData.getR()), Numeric.toBigInt(signatureData.getS()));
        BigInteger k = Sign.recoverFromSignature(signatureData.getV() - 27, sig, hash);
        return publicKey.equals(k);
    }

    public static ECDSASignature sign(byte[] transactionHash, BigInteger privateKey) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(privateKey, Sign.CURVE);
        signer.init(true, (CipherParameters)privKey);
        Object[] components = signer.generateSignature2(transactionHash);
        return new ECDSASignature((BigInteger)components[0], (BigInteger)components[1], (ECPoint)components[2]);
    }
}

