/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.fisco.bcos.web3j.crypto.HashInterface;
import org.fisco.bcos.web3j.crypto.SHA3Digest;
import org.fisco.bcos.web3j.utils.Numeric;

public class Hash {
    private static HashInterface hashInterface = new SHA3Digest();

    private Hash() {
    }

    public static HashInterface getHashInterface() {
        return hashInterface;
    }

    public static void setHashInterface(HashInterface hashInterface) {
        Hash.hashInterface = hashInterface;
    }

    public static String sha3(String hexInput) {
        return hashInterface.hash(hexInput);
    }

    public static byte[] sha3(byte[] input, int offset, int length) {
        return hashInterface.hash(input, offset, length);
    }

    public static byte[] sha3(byte[] input) {
        return hashInterface.hash(input, 0, input.length);
    }

    public static String sha3String(String utf8String) {
        return Numeric.toHexString(Hash.sha3(utf8String.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't find a SHA-256 provider", e);
        }
    }

    public static byte[] hmacSha512(byte[] key, byte[] input) {
        HMac hMac = new HMac((Digest)new SHA512Digest());
        hMac.init((CipherParameters)new KeyParameter(key));
        hMac.update(input, 0, input.length);
        byte[] out = new byte[64];
        hMac.doFinal(out, 0);
        return out;
    }

    public static byte[] sha256hash160(byte[] input) {
        byte[] sha256 = Hash.sha256(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

