/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import org.fisco.bcos.web3j.utils.Numeric;

public class RawTransaction
implements Serializable {
    private static final long serialVersionUID = -5580814755985097996L;
    private BigInteger randomid;
    private BigInteger gasPrice;
    private BigInteger gasLimit;
    private BigInteger blockLimit;
    private String to;
    private BigInteger value;
    private String data;
    @Deprecated
    private BigInteger version;

    protected RawTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value, String data) {
        this.randomid = randomid;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.blockLimit = blockLimit;
        this.to = to;
        this.value = value;
        if (data != null) {
            this.data = Numeric.cleanHexPrefix(data);
        }
    }

    public static RawTransaction createContractTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, BigInteger value, String init) {
        return new RawTransaction(randomid, gasPrice, gasLimit, blockLimit, "", value, init);
    }

    public static RawTransaction createEtherTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value) {
        return new RawTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, "");
    }

    public static RawTransaction createTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, String data) {
        return RawTransaction.createTransaction(randomid, gasPrice, gasLimit, blockLimit, to, BigInteger.ZERO, data);
    }

    public static RawTransaction createTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value, String data) {
        return new RawTransaction(randomid, gasPrice, gasLimit, blockLimit, to, value, data);
    }

    public BigInteger getRandomid() {
        return this.randomid;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public BigInteger getBlockLimit() {
        return this.blockLimit;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getData() {
        return this.data;
    }

    @Deprecated
    public BigInteger getVersion() {
        return this.version;
    }
}

