/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.fisco.bcos.web3j.crypto.gm.KeyInfoInterface;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KeyInfo
implements KeyInfoInterface {
    private static String privateKey;
    private static String publicKey;
    private static String account;
    private static Logger logger;
    public static final String privJsonKey = "privateKey";
    public static final String pubJsonKey = "publicKey";
    public static final String accountJsonKey = "account";

    KeyInfo(String publicKey, String privateKey, String account) {
        KeyInfo.privateKey = privateKey;
        KeyInfo.publicKey = publicKey;
        KeyInfo.account = account;
    }

    KeyInfo() {
    }

    public void setPrivateKey(String privKey) {
        privateKey = privKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPublicKey(String pubKey) {
        publicKey = pubKey;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setAccount(String account) {
        KeyInfo.account = account;
    }

    public String getAccount() {
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String keyFile) {
        String string;
        InputStreamReader reader = null;
        BufferedReader bufReader = null;
        try {
            File file = new File(keyFile);
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            if (reader != null) {
                bufReader = new BufferedReader(reader);
            }
            String line = null;
            String content = "";
            if (bufReader != null) {
                while ((line = bufReader.readLine()) != null) {
                    content = content + line;
                }
                System.out.println("read file " + keyFile + ", result:" + content);
            }
            string = content;
        }
        catch (Exception e) {
            String string2;
            try {
                logger.error("read file " + keyFile + " failed, error message:" + e.getMessage());
                string2 = null;
            }
            catch (Throwable throwable) {
                KeyInfo.ReleaseBufferedReader(bufReader);
                KeyInfo.ReleaseInputStream(reader);
                throw throwable;
            }
            KeyInfo.ReleaseBufferedReader(bufReader);
            KeyInfo.ReleaseInputStream(reader);
            return string2;
        }
        KeyInfo.ReleaseBufferedReader(bufReader);
        KeyInfo.ReleaseInputStream(reader);
        return string;
    }

    private static void ReleaseInputStream(InputStreamReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error("close InputStreamReader failed, error message:" + e.getMessage());
        }
    }

    private static void ReleaseBufferedReader(BufferedReader bufReader) {
        try {
            if (bufReader != null) {
                bufReader.close();
            }
        }
        catch (Exception e) {
            logger.error("close BufferedReader failed, error message: " + e.getMessage());
        }
    }

    @Override
    public int loadKeyInfo(String keyFile) {
        String keyInfoJsonStr = KeyInfo.readFile(keyFile);
        if (keyInfoJsonStr == null) {
            System.out.println("load key information failed");
            logger.error("load key information failed");
            return 10000;
        }
        System.out.println("");
        System.out.println("===key info:" + keyInfoJsonStr);
        try {
            Account key = (Account)ObjectMapperFactory.getObjectMapper().readValue(keyInfoJsonStr, Account.class);
            privateKey = key.getPrivateKey();
            publicKey = key.getPublicKey();
            account = key.getAccount();
            System.out.println("");
            System.out.println("====LOADED KEY INFO ===");
            System.out.println("* private key:" + privateKey);
            System.out.println("* public key :" + publicKey);
            System.out.println("* account: " + account);
            return 0;
        }
        catch (Exception e) {
            System.out.println("load private key from " + keyFile + " failed, error message:" + e.getMessage());
            return 10002;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeFile(String keyFile, String content) {
        File file = null;
        try (PrintStream ps = null;){
            file = new File(keyFile);
            ps = new PrintStream(new FileOutputStream(file));
            ps.println(content);
            int n = 0;
            return n;
        }
        return 10003;
    }

    @Override
    public int storeKeyInfo(String keyFile) {
        try {
            Account key = new Account();
            key.setPrivateKey(this.getPrivateKey());
            key.setPublicKey(this.getPublicKey());
            key.setAccount(this.getAccount());
            String keyJsonInfo = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)key);
            System.out.println("== SAVED KEY INFO: " + keyJsonInfo);
            return KeyInfo.writeFile(keyFile, keyJsonInfo);
        }
        catch (Exception e) {
            System.out.println("store keyInfo to " + keyFile + " failed, error message: " + e.getMessage());
            logger.error("store keyInfo to " + keyFile + " failed, error message: " + e.getMessage());
            return 10003;
        }
    }

    static {
        logger = LoggerFactory.getLogger(KeyInfo.class);
    }

    private static class Account {
        private String privateKey;
        private String publicKey;
        private String account;

        private Account() {
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }
    }
}

