/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.consensus;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.consensus.Consensus;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class ConsensusService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static String ConsensusPrecompileAddress = "0x0000000000000000000000000000000000001003";
    private Web3j web3j;
    private Consensus consensus;

    public ConsensusService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.web3j = web3j;
        this.consensus = Consensus.load(ConsensusPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
    }

    public String addSealer(String nodeID) throws Exception {
        TransactionReceipt receipt = this.addSealerAndRetReceipt(nodeID);
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt addSealerAndRetReceipt(String nodeID) throws Exception {
        return this.consensus.addSealer(nodeID).send();
    }

    public String addObserver(String nodeID) throws Exception {
        TransactionReceipt receipt = this.addObserverAndRetReceipt(nodeID);
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt addObserverAndRetReceipt(String nodeID) throws Exception {
        return this.consensus.addObserver(nodeID).send();
    }

    public String removeNode(String nodeId) throws Exception {
        List groupPeers = (List)this.web3j.getGroupPeers().send().getResult();
        if (!groupPeers.contains(nodeId)) {
            return PrecompiledCommon.transferToJson(-51103);
        }
        TransactionReceipt receipt = null;
        try {
            receipt = this.removeNodeAndRetReceipt(nodeId);
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("Don't send requests to this group")) {
                return PrecompiledCommon.transferToJson(0);
            }
            throw e;
        }
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt removeNodeAndRetReceipt(String nodeId) throws Exception {
        return this.consensus.remove(nodeId).send();
    }

    private boolean isValidNodeID(String _nodeID) throws IOException, JsonProcessingException {
        boolean flag = false;
        List nodeIDs = (List)this.web3j.getNodeIDList().send().getResult();
        for (String nodeID : nodeIDs) {
            if (!_nodeID.equals(nodeID)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

