/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.permission;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.abi.FunctionReturnDecoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.abi.datatypes.Utf8String;
import org.fisco.bcos.web3j.abi.datatypes.generated.Int256;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.EncryptType;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.RemoteCall;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple1;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.fisco.bcos.web3j.tx.Contract;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.txdecode.TransactionDecoder;

public class Permission
extends Contract {
    public static String BINARY = "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";
    public static final String ABI = "[{\"constant\":false,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"},{\"name\":\"addr\",\"type\":\"string\"}],\"name\":\"insert\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"}],\"name\":\"queryByName\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"},{\"name\":\"addr\",\"type\":\"string\"}],\"name\":\"remove\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"}],\"name\":\"queryPermission\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"},{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"grantWrite\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"},{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"revokeWrite\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]";
    public static final TransactionDecoder transactionDecoder = new TransactionDecoder("[{\"constant\":false,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"},{\"name\":\"addr\",\"type\":\"string\"}],\"name\":\"insert\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"}],\"name\":\"queryByName\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"table_name\",\"type\":\"string\"},{\"name\":\"addr\",\"type\":\"string\"}],\"name\":\"remove\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"}],\"name\":\"queryPermission\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"},{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"grantWrite\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"contractAddr\",\"type\":\"address\"},{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"revokeWrite\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]", BINARY);
    public static String SM_BINARY = "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";
    public static final String FUNC_INSERT = "insert";
    public static final String FUNC_QUERYBYNAME = "queryByName";
    public static final String FUNC_REMOVE = "remove";
    public static final String FUNC_QUERYPERMISSION = "queryPermission";
    public static final String FUNC_GRANTWRITE = "grantWrite";
    public static final String FUNC_REVOKEWRITE = "revokeWrite";

    @Deprecated
    protected Permission(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(Permission.getBinary(), contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Permission(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(Permission.getBinary(), contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Permission(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(Permission.getBinary(), contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Permission(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(Permission.getBinary(), contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static String getBinary() {
        return EncryptType.encryptType == 0 ? BINARY : SM_BINARY;
    }

    public static TransactionDecoder getTransactionDecoder() {
        return transactionDecoder;
    }

    public RemoteCall<TransactionReceipt> insert(String table_name, String addr) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void insert(String table_name, String addr, TransactionSucCallback callback) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String insertSeq(String table_name, String addr) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public Tuple2<String, String> getInsertInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getInsertOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public RemoteCall<String> queryByName(String table_name) {
        Function function = new Function(FUNC_QUERYBYNAME, Arrays.asList(new Utf8String(table_name)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> remove(String table_name, String addr) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void remove(String table_name, String addr, TransactionSucCallback callback) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String removeSeq(String table_name, String addr) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(table_name), new Utf8String(addr)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public Tuple2<String, String> getRemoveInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getRemoveOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public RemoteCall<String> queryPermission(String contractAddr) {
        Function function = new Function(FUNC_QUERYPERMISSION, Arrays.asList(new Address(contractAddr)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> grantWrite(String contractAddr, String user) {
        Function function = new Function(FUNC_GRANTWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void grantWrite(String contractAddr, String user, TransactionSucCallback callback) {
        Function function = new Function(FUNC_GRANTWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String grantWriteSeq(String contractAddr, String user) {
        Function function = new Function(FUNC_GRANTWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public Tuple2<String, String> getGrantWriteInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_GRANTWRITE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getGrantWriteOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_GRANTWRITE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public RemoteCall<TransactionReceipt> revokeWrite(String contractAddr, String user) {
        Function function = new Function(FUNC_REVOKEWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void revokeWrite(String contractAddr, String user, TransactionSucCallback callback) {
        Function function = new Function(FUNC_REVOKEWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String revokeWriteSeq(String contractAddr, String user) {
        Function function = new Function(FUNC_REVOKEWRITE, Arrays.asList(new Address(contractAddr), new Address(user)), Collections.emptyList());
        return this.createTransactionSeq(function);
    }

    public Tuple2<String, String> getRevokeWriteInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REVOKEWRITE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getRevokeWriteOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REVOKEWRITE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    @Deprecated
    public static Permission load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Permission(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Permission load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Permission(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Permission load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Permission(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Permission load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Permission(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<Permission> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return Permission.deployRemoteCall(Permission.class, web3j, credentials, contractGasProvider, Permission.getBinary(), "");
    }

    @Deprecated
    public static RemoteCall<Permission> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return Permission.deployRemoteCall(Permission.class, web3j, credentials, gasPrice, gasLimit, Permission.getBinary(), "");
    }

    public static RemoteCall<Permission> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return Permission.deployRemoteCall(Permission.class, web3j, transactionManager, contractGasProvider, Permission.getBinary(), "");
    }

    @Deprecated
    public static RemoteCall<Permission> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return Permission.deployRemoteCall(Permission.class, web3j, transactionManager, gasPrice, gasLimit, Permission.getBinary(), "");
    }
}

