/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.permission;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.permission.Permission;
import org.fisco.bcos.web3j.precompile.permission.PermissionInfo;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class PermissionService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static String PermissionPrecompileAddress = "0x0000000000000000000000000000000000001005";
    private Permission permission;
    private Web3j web3j;
    private Credentials credentials;

    public PermissionService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.permission = Permission.load(PermissionPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
        this.web3j = web3j;
        this.credentials = credentials;
    }

    public List<PermissionInfo> queryPermission(String address) throws Exception {
        String permissionInfo = this.permission.queryPermission(address).send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(permissionInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }

    public String grantWrite(String address, String user) throws Exception {
        TransactionReceipt transactionReceipt = this.grantWriteAndRetReceipt(address, user);
        return PrecompiledCommon.handleTransactionReceipt(transactionReceipt, this.web3j);
    }

    public TransactionReceipt grantWriteAndRetReceipt(String address, String user) throws Exception {
        return this.permission.grantWrite(address, user).send();
    }

    public String revokeWrite(String address, String user) throws Exception {
        TransactionReceipt receipt = this.revokeWriteAndRetReceipt(address, user);
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt revokeWriteAndRetReceipt(String address, String user) throws Exception {
        return this.permission.revokeWrite(address, user).send();
    }

    public String grantUserTableManager(String tableName, String grantress) throws Exception {
        return this.grant(tableName, grantress);
    }

    public String revokeUserTableManager(String tableName, String grantress) throws Exception {
        return this.revoke(tableName, grantress);
    }

    public List<PermissionInfo> listUserTableManager(String tableName) throws Exception {
        return this.list(tableName);
    }

    public String grantDeployAndCreateManager(String grantees) throws Exception {
        return this.grant("_sys_tables_", grantees);
    }

    public String revokeDeployAndCreateManager(String grantees) throws Exception {
        return this.revoke("_sys_tables_", grantees);
    }

    public List<PermissionInfo> listDeployAndCreateManager() throws Exception {
        return this.list("_sys_tables_");
    }

    public String grantPermissionManager(String grantress) throws Exception {
        return this.grant("_sys_table_access_", grantress);
    }

    public String revokePermissionManager(String grantress) throws Exception {
        return this.revoke("_sys_table_access_", grantress);
    }

    public List<PermissionInfo> listPermissionManager() throws Exception {
        return this.list("_sys_table_access_");
    }

    public String grantNodeManager(String grantress) throws Exception {
        return this.grant("_sys_consensus_", grantress);
    }

    public String revokeNodeManager(String grantress) throws Exception {
        return this.revoke("_sys_consensus_", grantress);
    }

    public List<PermissionInfo> listNodeManager() throws Exception {
        return this.list("_sys_consensus_");
    }

    public String grantCNSManager(String grantress) throws Exception {
        return this.grant("_sys_cns_", grantress);
    }

    public String revokeCNSManager(String grantress) throws Exception {
        return this.revoke("_sys_cns_", grantress);
    }

    public List<PermissionInfo> listCNSManager() throws Exception {
        return this.list("_sys_cns_");
    }

    public String grantSysConfigManager(String grantress) throws Exception {
        return this.grant("_sys_config_", grantress);
    }

    public String revokeSysConfigManager(String grantress) throws Exception {
        return this.revoke("_sys_config_", grantress);
    }

    public TransactionReceipt revokeSysConfigManagerAndRetReceipt(String grantress) throws Exception {
        return this.revokeAndRetReceipt("_sys_config_", grantress);
    }

    public List<PermissionInfo> listSysConfigManager() throws Exception {
        return this.list("_sys_config_");
    }

    public String grant(String tableName, String grandness) throws Exception {
        TransactionReceipt receipt = this.grantAndRetReceipt(tableName, grandness);
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt grantAndRetReceipt(String tableName, String grantress) throws Exception {
        return this.permission.insert(tableName, grantress).send();
    }

    public String revoke(String tableName, String address) throws Exception {
        TransactionReceipt receipt = this.revokeAndRetReceipt(tableName, address);
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public TransactionReceipt revokeAndRetReceipt(String tableName, String address) throws Exception {
        return this.permission.remove(tableName, address).send();
    }

    private List<PermissionInfo> list(String tableName) throws Exception {
        String permissionInfo = this.permission.queryByName(tableName).send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(permissionInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }
}

