/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.core.Response;

public class ConsensusStatus
extends Response<ConsensusInfo> {
    @Override
    @JsonDeserialize(using=ConsensusStatusDeserializer.class)
    public void setResult(ConsensusInfo result) {
        super.setResult(result);
    }

    public ConsensusInfo getConsensusStatus() {
        return (ConsensusInfo)this.getResult();
    }

    public static class ConsensusStatusDeserializer
    extends JsonDeserializer<ConsensusInfo> {
        private ObjectMapper objecMapper = ObjectMapperFactory.getObjectMapper();

        public ConsensusInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            BasicConsensusInfo baseConsensusInfo = null;
            List viewInfos = null;
            if (node.size() > 0) {
                baseConsensusInfo = (BasicConsensusInfo)this.objecMapper.readValue(node.get(0).toString(), BasicConsensusInfo.class);
                Integer sealersNum = Integer.valueOf(baseConsensusInfo.getNodeNum());
                baseConsensusInfo.setSealerList(new ArrayList<String>(sealersNum));
                Integer i = 0;
                while (i < sealersNum) {
                    String key = "sealer." + String.valueOf(i);
                    if (node.get(0).has(key)) {
                        baseConsensusInfo.getSealerList().add(i, node.get(0).get(key).asText());
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
            if (node.size() > 1) {
                viewInfos = (List)this.objecMapper.readValue(node.get(1).toString(), (TypeReference)new TypeReference<List<ViewInfo>>(){});
            }
            return new ConsensusInfo(baseConsensusInfo, viewInfos);
        }
    }

    public static class ConsensusInfo {
        private BasicConsensusInfo baseConsensusInfo;
        private List<ViewInfo> viewInfos;

        public ConsensusInfo() {
        }

        public ConsensusInfo(BasicConsensusInfo baseConsensusInfo, List<ViewInfo> viewInfos) {
            this.baseConsensusInfo = baseConsensusInfo;
            this.viewInfos = viewInfos;
        }

        public BasicConsensusInfo getBaseConsensusInfo() {
            return this.baseConsensusInfo;
        }

        public void setBaseConsensusInfo(BasicConsensusInfo baseConsensusInfo) {
            this.baseConsensusInfo = baseConsensusInfo;
        }

        public List<ViewInfo> getViewInfos() {
            return this.viewInfos;
        }

        public void setViewInfos(List<ViewInfo> viewInfos) {
            this.viewInfos = viewInfos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsensusInfo that = (ConsensusInfo)o;
            return Objects.equals(this.baseConsensusInfo, that.baseConsensusInfo) && Objects.equals(this.viewInfos, that.viewInfos);
        }

        public int hashCode() {
            return Objects.hash(this.baseConsensusInfo, this.viewInfos);
        }

        public String toString() {
            return "ConsensusInfo{baseConsensusInfo=" + this.baseConsensusInfo + ", viewInfos=" + this.viewInfos + '}';
        }
    }

    public static class BasicConsensusInfo {
        private String nodeNum;
        @JsonProperty(value="node_index")
        private String nodeIndex;
        @JsonProperty(value="node index")
        private String raftNodeIndex;
        @JsonProperty(value="max_faulty_leader")
        private String maxFaultyNodeNum;
        @JsonProperty(value="sealer.")
        private List<String> sealerList;
        private String consensusedBlockNumber;
        private String highestblockNumber;
        private String groupId;
        private String protocolId;
        private String accountType;
        private String cfgErr;
        private String omitEmptyBlock;
        private String nodeId;
        private String allowFutureBlocks;
        private String connectedNodes;
        private String currentView;
        private String toView;
        private String leaderFailed;
        private String highestblockHash;
        private String leaderId;
        private String leaderIdx;

        public String getRaftNodeIndex() {
            return this.raftNodeIndex;
        }

        public void setRaftNodeIndex(String raftNodeIndex) {
            this.raftNodeIndex = raftNodeIndex;
        }

        public String getLeaderId() {
            return this.leaderId;
        }

        public void setLeaderId(String leaderId) {
            this.leaderId = leaderId;
        }

        public String getLeaderIdx() {
            return this.leaderIdx;
        }

        public void setLeaderIdx(String leaderIdx) {
            this.leaderIdx = leaderIdx;
        }

        public String getNodeIndex() {
            return this.nodeIndex;
        }

        public void setNodeIndex(String nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        public String getHighestblockHash() {
            return this.highestblockHash;
        }

        public void setHighestblockHash(String highestblockHash) {
            this.highestblockHash = highestblockHash;
        }

        public String getNodeNum() {
            return this.nodeNum;
        }

        public void setNodeNum(String nodeNum) {
            this.nodeNum = nodeNum;
        }

        public String getMaxFaultyNodeNum() {
            return this.maxFaultyNodeNum;
        }

        public void setMaxFaultyNodeNum(String maxFaultyNodeNum) {
            this.maxFaultyNodeNum = maxFaultyNodeNum;
        }

        public List<String> getSealerList() {
            return this.sealerList;
        }

        public void setSealerList(List<String> sealerList) {
            this.sealerList = sealerList;
        }

        public String getConsensusedBlockNumber() {
            return this.consensusedBlockNumber;
        }

        public void setConsensusedBlockNumber(String consensusedBlockNumber) {
            this.consensusedBlockNumber = consensusedBlockNumber;
        }

        public String getHighestblockNumber() {
            return this.highestblockNumber;
        }

        public void setHighestblockNumber(String highestblockNumber) {
            this.highestblockNumber = highestblockNumber;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getProtocolId() {
            return this.protocolId;
        }

        public void setProtocolId(String protocolId) {
            this.protocolId = protocolId;
        }

        public String getAccountType() {
            return this.accountType;
        }

        public void setAccountType(String accountType) {
            this.accountType = accountType;
        }

        public String getCfgErr() {
            return this.cfgErr;
        }

        public void setCfgErr(String cfgErr) {
            this.cfgErr = cfgErr;
        }

        public String getOmitEmptyBlock() {
            return this.omitEmptyBlock;
        }

        public void setOmitEmptyBlock(String omitEmptyBlock) {
            this.omitEmptyBlock = omitEmptyBlock;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getAllowFutureBlocks() {
            return this.allowFutureBlocks;
        }

        public void setAllowFutureBlocks(String allowFutureBlocks) {
            this.allowFutureBlocks = allowFutureBlocks;
        }

        public String getConnectedNodes() {
            return this.connectedNodes;
        }

        public void setConnectedNodes(String connectedNodes) {
            this.connectedNodes = connectedNodes;
        }

        public String getCurrentView() {
            return this.currentView;
        }

        public void setCurrentView(String currentView) {
            this.currentView = currentView;
        }

        public String getToView() {
            return this.toView;
        }

        public void setToView(String toView) {
            this.toView = toView;
        }

        public String getLeaderFailed() {
            return this.leaderFailed;
        }

        public void setLeaderFailed(String leaderFailed) {
            this.leaderFailed = leaderFailed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicConsensusInfo that = (BasicConsensusInfo)o;
            return Objects.equals(this.nodeNum, that.nodeNum) && Objects.equals(this.nodeIndex, that.nodeIndex) && Objects.equals(this.maxFaultyNodeNum, that.maxFaultyNodeNum) && Objects.equals(this.sealerList, that.sealerList) && Objects.equals(this.consensusedBlockNumber, that.consensusedBlockNumber) && Objects.equals(this.highestblockNumber, that.highestblockNumber) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.protocolId, that.protocolId) && Objects.equals(this.accountType, that.accountType) && Objects.equals(this.cfgErr, that.cfgErr) && Objects.equals(this.omitEmptyBlock, that.omitEmptyBlock) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.allowFutureBlocks, that.allowFutureBlocks) && Objects.equals(this.connectedNodes, that.connectedNodes) && Objects.equals(this.currentView, that.currentView) && Objects.equals(this.toView, that.toView) && Objects.equals(this.leaderFailed, that.leaderFailed) && Objects.equals(this.highestblockHash, that.highestblockHash);
        }

        public int hashCode() {
            return Objects.hash(this.nodeNum, this.nodeIndex, this.maxFaultyNodeNum, this.sealerList, this.consensusedBlockNumber, this.highestblockNumber, this.groupId, this.protocolId, this.accountType, this.cfgErr, this.omitEmptyBlock, this.nodeId, this.allowFutureBlocks, this.connectedNodes, this.currentView, this.toView, this.leaderFailed, this.highestblockHash);
        }

        public String toString() {
            return "BasicConsensusInfo{nodeNum='" + this.nodeNum + '\'' + ", nodeIndex='" + this.nodeIndex + '\'' + ", maxFaultyNodeNum='" + this.maxFaultyNodeNum + '\'' + ", sealerList=" + this.sealerList + ", consensusedBlockNumber='" + this.consensusedBlockNumber + '\'' + ", highestblockNumber='" + this.highestblockNumber + '\'' + ", groupId='" + this.groupId + '\'' + ", protocolId='" + this.protocolId + '\'' + ", accountType='" + this.accountType + '\'' + ", cfgErr='" + this.cfgErr + '\'' + ", omitEmptyBlock='" + this.omitEmptyBlock + '\'' + ", nodeId='" + this.nodeId + '\'' + ", allowFutureBlocks='" + this.allowFutureBlocks + '\'' + ", connectedNodes='" + this.connectedNodes + '\'' + ", currentView='" + this.currentView + '\'' + ", toView='" + this.toView + '\'' + ", leaderFailed='" + this.leaderFailed + '\'' + ", highestblockHash='" + this.highestblockHash + '\'' + '}';
        }
    }

    public static class ViewInfo {
        private String nodeId;
        private String view;

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getView() {
            return this.view;
        }

        public void setView(String view) {
            this.view = view;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewInfo viewInfo = (ViewInfo)o;
            return Objects.equals(this.nodeId, viewInfo.nodeId) && Objects.equals(this.view, viewInfo.view);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.view);
        }

        public String toString() {
            return "ViewInfo{nodeId='" + this.nodeId + '\'' + ", view='" + this.view + '\'' + '}';
        }
    }
}

