/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.channel.event.filter.EventLogPushWithDecodeCallback;
import org.fisco.bcos.channel.event.filter.EventLogUserParams;
import org.fisco.bcos.fisco.EnumNodeVersion;
import org.fisco.bcos.web3j.abi.EventEncoder;
import org.fisco.bcos.web3j.abi.EventValues;
import org.fisco.bcos.web3j.abi.FunctionEncoder;
import org.fisco.bcos.web3j.abi.FunctionReturnDecoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.abi.datatypes.Event;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.Web3jService;
import org.fisco.bcos.web3j.protocol.channel.ChannelEthereumService;
import org.fisco.bcos.web3j.protocol.channel.StatusCode;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterName;
import org.fisco.bcos.web3j.protocol.core.JsonRpc2_0Web3j;
import org.fisco.bcos.web3j.protocol.core.RemoteCall;
import org.fisco.bcos.web3j.protocol.core.methods.request.Transaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.Call;
import org.fisco.bcos.web3j.protocol.core.methods.response.Code;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.NodeVersion;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionException;
import org.fisco.bcos.web3j.tx.ExtendedRawTransactionManager;
import org.fisco.bcos.web3j.tx.ManagedTransaction;
import org.fisco.bcos.web3j.tx.RawTransactionManager;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.exceptions.ContractCallException;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;
import org.fisco.bcos.web3j.tx.txdecode.TransactionDecoder;
import org.fisco.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Contract
extends ManagedTransaction {
    private static final Logger logger = LoggerFactory.getLogger(Contract.class);
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    public static final String BIN_NOT_PROVIDED = "Bin file was not provided";
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected ContractGasProvider gasProvider;
    protected TransactionReceipt transactionReceipt;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        super(web3j, transactionManager);
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
    }

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider gasProvider) {
        this(contractBinary, contractAddress, web3j, Contract.getTheTransactionManager(web3j, credentials), gasProvider);
    }

    public static TransactionManager getTheTransactionManager(Web3j web3j, Credentials credentials) {
        JsonRpc2_0Web3j jsonRpc2_0Web3j = (JsonRpc2_0Web3j)web3j;
        String chainId = "1";
        int groupId = 1;
        String version = "";
        String supportedVersion = "";
        NodeVersion.Version nodeVersion = null;
        try {
            groupId = jsonRpc2_0Web3j.getGroupId();
            nodeVersion = web3j.getNodeVersion().send().getNodeVersion();
            version = nodeVersion.getVersion();
            supportedVersion = nodeVersion.getSupportedVersion();
            if (EnumNodeVersion.BCOS_2_0_0_RC1.getVersion().equals(version) || EnumNodeVersion.BCOS_2_0_0_RC1.getVersion().equals(supportedVersion)) {
                version = EnumNodeVersion.BCOS_2_0_0_RC1.getVersion();
                logger.debug("fisco-bcos version:{}", (Object)version);
            } else {
                chainId = nodeVersion.getChainID();
                logger.debug("fisco-bcos version:{}, supported version:{}", (Object)version, (Object)supportedVersion);
            }
        }
        catch (Exception e) {
            logger.error("Query fisco-bcos version failed", (Throwable)e);
        }
        TransactionManager transactionManager = EnumNodeVersion.BCOS_2_0_0_RC1.getVersion().equals(version) ? new RawTransactionManager(web3j, credentials) : new ExtendedRawTransactionManager(web3j, credentials, BigInteger.valueOf(groupId), new BigInteger(chainId));
        transactionManager.setNodeVersion(nodeVersion);
        return transactionManager;
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, web3j, transactionManager, (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, web3j, Contract.getTheTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, Contract.getTheTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(ContractGasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public void setGasPrice(BigInteger newPrice) {
        this.gasProvider = new StaticGasProvider(newPrice, this.gasProvider.getGasLimit());
    }

    public BigInteger getGasPrice() {
        return this.gasProvider.getGasPrice();
    }

    public boolean isValid() throws IOException {
        if (this.contractBinary.equals(BIN_NOT_PROVIDED)) {
            throw new UnsupportedOperationException("Contract binary not present in contract wrapper, please generate your wrapper using -abiFile=<file>");
        }
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with web3j v2.2.0+");
        }
        Code gcode = this.web3j.getCode(this.contractAddress, DefaultBlockParameterName.LATEST).send();
        if (gcode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix(gcode.getCode());
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode(function);
        Call ethCall = this.web3j.call(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), this.defaultBlockParameter).send();
        String value = ethCall.getValue().getOutput();
        return FunctionReturnDecoder.decode(value, function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected TransactionReceipt executeTransaction(Function function) throws IOException {
        Callback callback = new Callback();
        this.asyncExecuteTransaction(FunctionEncoder.encode(function), function.getName(), callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return callback.receipt;
    }

    protected TransactionReceipt executeTransaction(String data, BigInteger weiValue, String funcName) throws TransactionException, IOException {
        Callback callback = new Callback();
        this.asyncExecuteTransaction(data, funcName, callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        TransactionReceipt receipt = callback.receipt;
        if (!receipt.isStatusOK()) {
            String status = receipt.getStatus();
            BigInteger gasUsed = receipt.getGasUsed();
            String message = StatusCode.getStatusMessage(receipt.getStatus(), receipt.getMessage());
            logger.trace(" execute transaction not successfully, hash: {}, status: {}, message: {}, gasUsed: {}", new Object[]{receipt.getTransactionHash(), receipt.getStatus(), receipt.getMessage(), receipt.getGasUsed()});
            TransactionException transactionException = new TransactionException(message, status, gasUsed, receipt.getTransactionHash());
            transactionException.setReceipt(receipt);
            throw transactionException;
        }
        return receipt;
    }

    protected void asyncExecuteTransaction(Function function, TransactionSucCallback callback) {
        try {
            this.asyncExecuteTransaction(FunctionEncoder.encode(function), function.getName(), callback);
        }
        catch (IOException e) {
            logger.error(" IOException, contractAddress:{}, exception:{} ", (Object)this.getContractAddress(), (Object)e.getMessage());
        }
    }

    protected void asyncExecuteTransaction(String data, String funName, TransactionSucCallback callback) throws IOException {
        this.sendOnly(this.contractAddress, data, BigInteger.ZERO, this.gasProvider.getGasPrice(funName), this.gasProvider.getGasLimit(funName), callback);
    }

    protected String createTransactionSeq(Function function) {
        try {
            String signedTransaction = this.createSeq(this.contractAddress, FunctionEncoder.encode(function), BigInteger.ZERO, this.gasProvider.getGasPrice(function.getName()), this.gasProvider.getGasLimit(function.getName()));
            return signedTransaction;
        }
        catch (IOException e) {
            logger.error(" IOException, message:{}", (Object)e.getMessage());
            return "";
        }
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall<Type>(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall<List<Type>>(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function));
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value, FUNC_DEPLOY);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, Credentials.class, ContractGasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, credentials, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("e: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, TransactionManager.class, ContractGasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, transactionManager, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        return Contract.deploy(type, web3j, credentials, (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit), binary, encodedConstructor, value);
    }

    @Deprecated
    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        return Contract.deploy(type, web3j, transactionManager, (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit), binary, encodedConstructor, value);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public void registerEventLogPushFilter(TransactionDecoder decoder, EventLogUserParams params, EventLogPushWithDecodeCallback callback) {
        Web3jService service = ((JsonRpc2_0Web3j)this.web3j).web3jService();
        ChannelEthereumService channelEthereumService = (ChannelEthereumService)service;
        callback.setDecoder(decoder);
        channelEthereumService.getChannelService().registerEventLogFilter(params, callback);
    }

    public void registerEventLogPushFilter(String abi, String bin, String topic0, EventLogPushWithDecodeCallback callback) {
        this.registerEventLogPushFilter(abi, bin, topic0, new String(DefaultBlockParameterName.LATEST.getValue()), new String(DefaultBlockParameterName.LATEST.getValue()), new ArrayList<String>(), callback);
    }

    public void registerEventLogPushFilter(String abi, String bin, String topic0, String fromBlock, String toBlock, List<String> otherTopics, EventLogPushWithDecodeCallback callback) {
        EventLogUserParams filter = new EventLogUserParams();
        filter.setFromBlock(fromBlock);
        filter.setToBlock(toBlock);
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add(this.getContractAddress());
        filter.setAddresses(addresses);
        ArrayList<Object> topics = new ArrayList<Object>();
        topics.add(topic0);
        if (otherTopics != null) {
            for (String obj : otherTopics) {
                topics.add(obj);
            }
        }
        filter.setTopics(topics);
        TransactionDecoder decoder = new TransactionDecoder(abi, bin);
        this.registerEventLogPushFilter(decoder, filter, callback);
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode(event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List<Type> nonIndexedValues = FunctionReturnDecoder.decode(log.getData(), event.getNonIndexedParameters());
        List<TypeReference<Type>> indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue(topics.get(i + 1), indexedParameters.get(i));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return Contract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParameters(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, List<Log> logs) {
        return logs.stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList out = new ArrayList();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        private EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }

    class Callback
    extends TransactionSucCallback {
        public TransactionReceipt receipt;
        public Semaphore semaphore = new Semaphore(1, true);

        Callback() {
            try {
                this.semaphore.acquire(1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void onResponse(TransactionReceipt receipt) {
            this.receipt = receipt;
            this.semaphore.release();
        }
    }
}

