/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.crypto.ExtendedRawTransaction;
import org.fisco.bcos.web3j.precompile.cns.CnsService;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionException;
import org.fisco.bcos.web3j.tx.TransactionManager;

public abstract class ManagedTransaction {
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(22000000000L);
    protected Web3j web3j;
    protected TransactionManager transactionManager;
    @Deprecated
    protected CnsService cnsService;

    protected ManagedTransaction(Web3j web3j, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.web3j = web3j;
        this.cnsService = new CnsService(web3j, transactionManager.credentials);
    }

    @Deprecated
    public long getSyncThreshold() {
        return this.cnsService.getSyncThreshold();
    }

    @Deprecated
    public void setSyncThreshold(long syncThreshold) {
        this.cnsService.setSyncThreshold(syncThreshold);
    }

    protected TransactionReceipt send(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit) throws IOException, TransactionException {
        return this.transactionManager.executeTransaction(gasPrice, gasLimit, to, data, value, null);
    }

    protected void sendOnly(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit, TransactionSucCallback callback) throws IOException {
        this.transactionManager.sendTransaction(gasPrice, gasLimit, to, data, value, null, callback);
    }

    protected String createSeq(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit) throws IOException {
        ExtendedRawTransaction rawTransaction = this.transactionManager.createTransaction(gasPrice, gasLimit, to, data, value, null);
        return this.transactionManager.sign(rawTransaction);
    }
}

