/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx.txdecode;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fisco.bcos.web3j.abi.EventEncoder;
import org.fisco.bcos.web3j.abi.EventValues;
import org.fisco.bcos.web3j.abi.FunctionEncoder;
import org.fisco.bcos.web3j.abi.FunctionReturnDecoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.Type;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.core.methods.response.AbiDefinition;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.fisco.bcos.web3j.tx.txdecode.BaseException;
import org.fisco.bcos.web3j.tx.txdecode.ContractAbiUtil;
import org.fisco.bcos.web3j.tx.txdecode.EventResultEntity;
import org.fisco.bcos.web3j.tx.txdecode.InputAndOutputResult;
import org.fisco.bcos.web3j.tx.txdecode.LogResult;
import org.fisco.bcos.web3j.tx.txdecode.ResultEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionDecoder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionDecoder.class);
    private String abi = "";
    private String bin = "";
    private Map<String, AbiDefinition> methodIDMap;

    public TransactionDecoder(String abi) {
        this(abi, "");
    }

    public TransactionDecoder(String abi, String bin) {
        this.abi = abi;
        this.bin = bin;
        this.methodIDMap = new HashMap<String, AbiDefinition>();
        List<AbiDefinition> funcAbiDefinitionList = ContractAbiUtil.getFuncAbiDefinition(abi);
        for (AbiDefinition abiDefinition : funcAbiDefinitionList) {
            String methodSign = this.decodeMethodSign(abiDefinition);
            String methodID = FunctionEncoder.buildMethodId(methodSign);
            this.methodIDMap.put(methodID, abiDefinition);
        }
    }

    private String addHexPrefixToString(String s) {
        if (!s.startsWith("0x")) {
            return "0x" + s;
        }
        return s;
    }

    public String decodeInputReturnJson(String input) throws JsonProcessingException, BaseException {
        input = this.addHexPrefixToString(input);
        AbiDefinition abiFunc = this.selectAbiDefinition(input);
        InputAndOutputResult inputAndOutputResult = this.decodeInputReturnObject(input);
        String result = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)inputAndOutputResult);
        return result;
    }

    public InputAndOutputResult decodeInputReturnObject(String input) throws BaseException {
        String updatedInput = this.addHexPrefixToString(input);
        AbiDefinition abiDefinition = this.selectAbiDefinition(updatedInput);
        List<AbiDefinition.NamedType> inputTypes = abiDefinition.getInputs();
        List<TypeReference<?>> inputTypeReferences = ContractAbiUtil.paramFormat(inputTypes);
        Function function = new Function(abiDefinition.getName(), null, inputTypeReferences);
        List<Type> resultType = FunctionReturnDecoder.decode(updatedInput.substring(10), function.getOutputParameters());
        ArrayList<ResultEntity> resultList = new ArrayList<ResultEntity>();
        for (int i = 0; i < inputTypes.size(); ++i) {
            resultList.add(new ResultEntity(inputTypes.get(i).getName(), inputTypes.get(i).getType(), resultType.get(i)));
        }
        String methodSign = this.decodeMethodSign(abiDefinition);
        return new InputAndOutputResult(methodSign, FunctionEncoder.buildMethodId(methodSign), resultList);
    }

    public String decodeOutputReturnJson(String input, String output) throws JsonProcessingException, BaseException {
        InputAndOutputResult inputAndOutputResult = this.decodeOutputReturnObject(input, output);
        String result = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)inputAndOutputResult);
        return result;
    }

    public InputAndOutputResult decodeOutputReturnObject(String input, String output) throws BaseException {
        String updatedInput = this.addHexPrefixToString(input);
        String updatedOutput = this.addHexPrefixToString(output);
        AbiDefinition abiDefinition = this.selectAbiDefinition(updatedInput);
        List<AbiDefinition.NamedType> outputTypes = abiDefinition.getOutputs();
        List<TypeReference<?>> outputTypeReference = ContractAbiUtil.paramFormat(outputTypes);
        Function function = new Function(abiDefinition.getName(), null, outputTypeReference);
        List<Type> resultType = FunctionReturnDecoder.decode(updatedOutput, function.getOutputParameters());
        ArrayList<ResultEntity> resultList = new ArrayList<ResultEntity>();
        for (int i = 0; i < outputTypes.size(); ++i) {
            resultList.add(new ResultEntity(outputTypes.get(i).getName(), outputTypes.get(i).getType(), resultType.get(i)));
        }
        String methodSign = this.decodeMethodSign(abiDefinition);
        return new InputAndOutputResult(methodSign, FunctionEncoder.buildMethodId(methodSign), resultList);
    }

    public String decodeEventReturnJson(String logs) throws BaseException, IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Log.class);
        List logList = (List)mapper.readValue(logs, (JavaType)listType);
        Map<String, List<List<EventResultEntity>>> resultEntityMap = this.decodeEventReturnObject(logList);
        String result = mapper.writeValueAsString(resultEntityMap);
        return result;
    }

    public String decodeEventReturnJson(List<Log> logList) throws BaseException, IOException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        Map<String, List<List<EventResultEntity>>> resultEntityMap = this.decodeEventReturnObject(logList);
        String result = mapper.writeValueAsString(resultEntityMap);
        return result;
    }

    public Map<String, List<List<EventResultEntity>>> decodeEventReturnObject(List<Log> logList) throws BaseException, IOException {
        LinkedHashMap<String, List<List<EventResultEntity>>> resultEntityMap = new LinkedHashMap<String, List<List<EventResultEntity>>>();
        for (Log log : logList) {
            Tuple2<AbiDefinition, List<EventResultEntity>> resultTuple2 = this.decodeEventReturnObject(log);
            if (null == resultTuple2) continue;
            AbiDefinition abiDefinition = resultTuple2.getValue1();
            String eventName = this.decodeMethodSign(abiDefinition);
            if (resultEntityMap.containsKey(eventName)) {
                ((List)resultEntityMap.get(eventName)).add(resultTuple2.getValue2());
                continue;
            }
            ArrayList<List<EventResultEntity>> eventEntityList = new ArrayList<List<EventResultEntity>>();
            eventEntityList.add(resultTuple2.getValue2());
            resultEntityMap.put(eventName, eventEntityList);
        }
        return resultEntityMap;
    }

    public LogResult decodeEventLogReturnObject(Log log) throws BaseException {
        List<AbiDefinition> abiDefinitions = ContractAbiUtil.getEventAbiDefinitions(this.abi);
        LogResult result = new LogResult();
        for (AbiDefinition abiDefinition : abiDefinitions) {
            EventResultEntity eventEntity;
            int i;
            EventValues eventValued;
            String eventSignature = EventEncoder.buildEventSignature(this.decodeMethodSign(abiDefinition));
            List<String> topics = log.getTopics();
            if (null == topics || topics.isEmpty() || !topics.get(0).equals(eventSignature) || null == (eventValued = ContractAbiUtil.decodeEvent(log, abiDefinition))) continue;
            ArrayList<EventResultEntity> resultEntityList = new ArrayList<EventResultEntity>();
            List<AbiDefinition.NamedType> inputs = abiDefinition.getInputs();
            List indexedInputs = inputs.stream().filter(AbiDefinition.NamedType::isIndexed).collect(Collectors.toList());
            List nonIndexedInputs = inputs.stream().filter(p -> !p.isIndexed()).collect(Collectors.toList());
            for (i = 0; i < indexedInputs.size(); ++i) {
                eventEntity = new EventResultEntity(((AbiDefinition.NamedType)indexedInputs.get(i)).getName(), ((AbiDefinition.NamedType)indexedInputs.get(i)).getType(), true, eventValued.getIndexedValues().get(i));
                resultEntityList.add(eventEntity);
            }
            for (i = 0; i < nonIndexedInputs.size(); ++i) {
                eventEntity = new EventResultEntity(((AbiDefinition.NamedType)nonIndexedInputs.get(i)).getName(), ((AbiDefinition.NamedType)nonIndexedInputs.get(i)).getType(), false, eventValued.getNonIndexedValues().get(i));
                resultEntityList.add(eventEntity);
            }
            result.setLogParams(resultEntityList);
            result.setLog(log);
            logger.debug(" event log result: {}", (Object)result);
            return result;
        }
        return null;
    }

    public Tuple2<AbiDefinition, List<EventResultEntity>> decodeEventReturnObject(Log log) throws BaseException, IOException {
        Tuple2 result = null;
        List<AbiDefinition> abiDefinitions = ContractAbiUtil.getEventAbiDefinitions(this.abi);
        for (AbiDefinition abiDefinition : abiDefinitions) {
            EventResultEntity eventEntity;
            int i;
            EventValues eventValued;
            String eventSignature = EventEncoder.buildEventSignature(this.decodeMethodSign(abiDefinition));
            List<String> topics = log.getTopics();
            if (null == topics || topics.isEmpty() || !topics.get(0).equals(eventSignature) || null == (eventValued = ContractAbiUtil.decodeEvent(log, abiDefinition))) continue;
            ArrayList<EventResultEntity> resultEntityList = new ArrayList<EventResultEntity>();
            List<AbiDefinition.NamedType> inputs = abiDefinition.getInputs();
            List indexedInputs = inputs.stream().filter(AbiDefinition.NamedType::isIndexed).collect(Collectors.toList());
            List nonIndexedInputs = inputs.stream().filter(p -> !p.isIndexed()).collect(Collectors.toList());
            for (i = 0; i < indexedInputs.size(); ++i) {
                eventEntity = new EventResultEntity(((AbiDefinition.NamedType)indexedInputs.get(i)).getName(), ((AbiDefinition.NamedType)indexedInputs.get(i)).getType(), true, eventValued.getIndexedValues().get(i));
                resultEntityList.add(eventEntity);
            }
            for (i = 0; i < nonIndexedInputs.size(); ++i) {
                eventEntity = new EventResultEntity(((AbiDefinition.NamedType)nonIndexedInputs.get(i)).getName(), ((AbiDefinition.NamedType)nonIndexedInputs.get(i)).getType(), false, eventValued.getNonIndexedValues().get(i));
                resultEntityList.add(eventEntity);
            }
            result = new Tuple2(abiDefinition, resultEntityList);
            break;
        }
        return result;
    }

    private AbiDefinition selectAbiDefinition(String input) throws BaseException {
        String methodID = input.substring(0, 10);
        AbiDefinition abiDefinition = this.methodIDMap.get(methodID);
        if (abiDefinition == null) {
            throw new BaseException(201203, String.format("the method is not found in abi, method id:[%s]", methodID));
        }
        return abiDefinition;
    }

    private String decodeMethodSign(AbiDefinition abiDefinition) {
        List<AbiDefinition.NamedType> inputTypes = abiDefinition.getInputs();
        StringBuilder methodSign = new StringBuilder();
        methodSign.append(abiDefinition.getName());
        methodSign.append("(");
        String params = inputTypes.stream().map(AbiDefinition.NamedType::getType).collect(Collectors.joining(","));
        methodSign.append(params);
        methodSign.append(")");
        return methodSign.toString();
    }
}

