/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx.txdecode;

import java.io.File;
import java.io.IOException;
import org.fisco.bcos.web3j.solidity.compiler.CompilationResult;
import org.fisco.bcos.web3j.solidity.compiler.SolidityCompiler;
import org.fisco.bcos.web3j.tx.txdecode.CompileSolidityException;
import org.fisco.bcos.web3j.tx.txdecode.TransactionDecoder;

public class TransactionDecoderFactory {
    public static String SOLIDITY_PATH = "solidity";
    public static String SOL_POSTFIX = ".sol";
    public static String PREFIX_LIB = "Lib";

    public static TransactionDecoder buildTransactionDecoder(String abi, String bin) {
        return new TransactionDecoder(abi, bin);
    }

    public static TransactionDecoder buildTransactionDecoder(String contractName) throws IOException {
        File solFileList;
        if (contractName.startsWith(PREFIX_LIB)) {
            throw new IOException("Please don't provide a library solidity file.");
        }
        if (!contractName.endsWith(SOL_POSTFIX)) {
            contractName = contractName + SOL_POSTFIX;
        }
        if (!(solFileList = new File(SOLIDITY_PATH)).exists()) {
            throw new IOException("Please checkout the directory " + SOLIDITY_PATH + " is exist.");
        }
        File destSol = new File(SOLIDITY_PATH + File.separator + contractName);
        if (!destSol.exists()) {
            throw new IOException("There is no " + contractName + " in the directory of " + SOLIDITY_PATH);
        }
        contractName = contractName.substring(0, contractName.length() - SOL_POSTFIX.length());
        return TransactionDecoderFactory.compileContract(contractName, solFileList);
    }

    private static TransactionDecoder compileContract(String contractName, File solFileList) throws IOException, CompileSolidityException {
        File[] solFiles = solFileList.listFiles();
        String abi = "";
        String bin = "";
        for (File solFile : solFiles) {
            if (!solFile.getName().endsWith(SOL_POSTFIX) || solFile.getName().startsWith(PREFIX_LIB)) continue;
            SolidityCompiler.Result res = SolidityCompiler.compile(solFile, true, SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA);
            if ("".equals(res.output)) {
                throw new CompileSolidityException("Compile error: " + res.errors);
            }
            CompilationResult result = CompilationResult.parse(res.output);
            String name = solFile.getName().split("\\.")[0];
            CompilationResult.ContractMetadata contractMetadata = result.getContract(name);
            if (!contractName.equals(name)) continue;
            abi = contractMetadata.abi;
            bin = contractMetadata.bin;
            break;
        }
        return new TransactionDecoder(abi, bin);
    }
}

