/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.Fixture;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.utility.ParseUtility;
import fitnesse.components.CommandLine;
import fitnesse.components.FitProtocol;
import fitnesse.util.StreamReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public abstract class FitServerBridge {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public FixtureListener fixtureListener = new TablePrintingFixtureListener();
    private Counts counts = new Counts();
    protected OutputStream socketOutput;
    private StreamReader socketReader;
    private boolean verbose = true;
    private String host;
    private int port;
    private int socketToken;
    private Socket socket;
    protected int numberOfPages = 0;
    protected boolean showAllReports = false;

    public FitServerBridge(String host, int port, boolean verbose) {
        this.host = host;
        this.port = port;
        this.verbose = verbose;
    }

    public FitServerBridge() {
    }

    public void run(String[] argv) throws Exception {
        this.args(argv);
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.closeConnection();
        this.exit();
    }

    public void closeConnection() throws IOException {
        this.socket.close();
    }

    public void process() {
        this.fixture.listener = this.fixtureListener;
        try {
            int size = 1;
            while ((size = FitProtocol.readSize((StreamReader)this.socketReader)) != 0) {
                try {
                    this.print("processing document of size: " + size + "\n");
                    String document = FitProtocol.readDocument((StreamReader)this.socketReader, (int)size);
                    this.tables = new Parse(document);
                    this.doTables(this.tables);
                    this.print("\tresults: " + this.fixture.counts() + "\n");
                    this.counts.tally(this.fixture.counts);
                    ++this.numberOfPages;
                }
                catch (FitParseException e) {
                    this.exception((Exception)((Object)e));
                }
            }
            this.print("completion signal recieved\n");
        }
        catch (Exception e) {
            this.exception(e);
        }
    }

    public abstract void doTables(Parse var1);

    public String readDocument() throws Exception {
        int size = FitProtocol.readSize((StreamReader)this.socketReader);
        return FitProtocol.readDocument((StreamReader)this.socketReader, (int)size);
    }

    public void args(String[] argv) {
        CommandLine commandLine = new CommandLine("[-v] host port socketToken");
        if (commandLine.parse(argv)) {
            this.host = commandLine.getArgument("host");
            this.port = Integer.parseInt(commandLine.getArgument("port"));
            this.socketToken = Integer.parseInt(commandLine.getArgument("socketToken"));
            this.verbose = commandLine.hasOption("v");
        } else {
            this.usage();
        }
    }

    private void usage() {
        System.out.println("usage: java fit.FitServer [-v] host port socketTicket");
        System.out.println("\t-v\tverbose");
        System.exit(-1);
    }

    protected void exception(Exception e) {
        this.print("Exception occurred!\n");
        this.print("\t" + e.getMessage() + "\n");
        this.tables = new Parse("span", "Exception occurred: ", null, null);
        this.fixture.exception(this.tables, (Throwable)e);
        ++this.counts.exceptions;
        this.fixture.listener.tableFinished(this.tables);
        this.fixture.listener.tablesFinished(this.counts);
    }

    public void exit() throws Exception {
        this.print("exiting\n");
        this.print("\tend results: " + this.counts.toString() + "\n");
    }

    public int exitCode() {
        return this.counts.wrong + this.counts.exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String httpRequest) throws Exception {
        this.socket = new Socket(this.host, this.port);
        this.socketOutput = this.socket.getOutputStream();
        this.socketReader = new StreamReader(this.socket.getInputStream());
        byte[] bytes = httpRequest.getBytes("UTF-8");
        this.socketOutput.write(bytes);
        this.socketOutput.flush();
        this.print("http request sent\n");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        this.print("validating connection...");
        int statusSize = FitProtocol.readSize((StreamReader)this.socketReader);
        if (statusSize == 0) {
            this.print("...ok\n");
        } else {
            String errorMessage = FitProtocol.readDocument((StreamReader)this.socketReader, (int)statusSize);
            this.print("...failed bacuase: " + errorMessage + "\n");
            System.out.println("An error occured while connecting to client.");
            System.out.println(errorMessage);
            System.exit(-1);
        }
    }

    public Counts getCounts() {
        return this.counts;
    }

    private void print(String message) {
        if (this.verbose) {
            System.out.print(message);
        }
    }

    public static byte[] readTable(Parse table) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)byteBuffer, "UTF-8");
        PrintWriter writer = new PrintWriter(streamWriter);
        Parse more = table.more;
        table.more = null;
        if (table.trailer == null) {
            table.trailer = "";
        }
        table.print(writer);
        table.more = more;
        writer.close();
        return byteBuffer.toByteArray();
    }

    public void writeCounts(Counts count) throws IOException {
        FitProtocol.writeCounts((Counts)this.counts, (OutputStream)this.socketOutput);
    }

    public void showAllReports() {
        this.showAllReports = true;
    }

    class TablePrintingFixtureListener
    implements FixtureListener {
        TablePrintingFixtureListener() {
        }

        public void tableFinished(Parse table) {
            try {
                byte[] bytes = !FitServerBridge.this.showAllReports && FitServerBridge.this.numberOfPages > 1 && this.passed(table) ? ".".getBytes() : FitServerBridge.readTable(table);
                if (bytes.length > 0) {
                    FitProtocol.writeData((byte[])bytes, (OutputStream)FitServerBridge.this.socketOutput);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void tablesFinished(Counts count) {
            try {
                FitProtocol.writeCounts((Counts)count, (OutputStream)FitServerBridge.this.socketOutput);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private boolean passed(Parse table) {
            String s = ParseUtility.toString(table);
            return s.indexOf(" class=\"fail\"") < 0 && s.indexOf(" class=\"error\"") < 0;
        }
    }
}

