/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Parse;
import fitlibrary.FitLibraryFixture;
import fitlibrary.SetUpFixture;
import fitlibrary.suite.FlowControl;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class DoFixture
extends FitLibraryFixture
implements DoEvaluator {
    private DoTraverse doTraverse = new DoTraverse(this);
    private InFlowPageRunner inFlow = new InFlowPageRunner(this, false);

    public DoFixture() {
        this.setTraverse(this.doTraverse);
    }

    public DoFixture(Object sut) {
        this();
        this.setSystemUnderTest(sut);
    }

    protected void setTraverse(DoTraverse traverse) {
        this.doTraverse = traverse;
        super.setTraverse(traverse);
    }

    public final void interpretTables(Parse tables) {
        this.inFlow.run(new Tables(tables), 0, new TableListener(this.listener, this.testResults()));
    }

    public final Object interpret(Table table, TestResults testResults) {
        return ((DoTraverse)this.traverse()).interpretInFlow(table, testResults);
    }

    public void setStopOnError(boolean stopOnError) {
        this.inFlow.setStopOnError(stopOnError);
    }

    protected void abandon() {
        this.inFlow.setAbandon(true);
        this.doTraverse.abandonStorytest(null, null);
    }

    protected Object getExpectedResult() {
        return this.doTraverse.getExpectedResult();
    }

    public Object interpretInFlow(Table firstTable, TestResults testResults) {
        return this.doTraverse.interpretInFlow(firstTable, testResults);
    }

    public final Object interpretWholeTable(Table table, TableListener tableListener) {
        return this.doTraverse.interpretWholeTable(table, tableListener);
    }

    public void setUp(Table firstTable, TestResults testResults) {
        this.doTraverse.setUp(firstTable, testResults);
    }

    public void tearDown(Table firstTable, TestResults testResults) {
        this.doTraverse.tearDown(firstTable, testResults);
    }

    protected void setGatherExpectedForGeneration(boolean gatherExpectedForGeneration) {
        this.doTraverse.setGatherExpectedForGeneration(gatherExpectedForGeneration);
    }

    public void setSetUpFixture(SetUpFixture setUpFixture) {
        this.doTraverse.setSetUpTraverse(setUpFixture.getSetUpTraverse());
    }

    void finishSettingUp() {
        this.doTraverse.setSettingUp(false);
    }

    public void doNotTearDownAutomatically() {
        this.doTraverse.doNotTearDownAutomatically();
    }

    public void registerFlowControl(FlowControl flowControl) {
        this.doTraverse.registerFlowControl(flowControl);
    }
}

