/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.FixtureBridge;
import fit.Parse;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

public abstract class FitLibraryFixture
extends FixtureBridge
implements Evaluator {
    private Traverse traverse;
    private TypedObject typedObjectUnderTest = Traverse.asTypedObject(null);

    protected void registerParseDelegate(Class type, Class parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        this.typedObjectUnderTest = Traverse.asTypedObject(sut);
    }

    public Object getSystemUnderTest() {
        return this.typedObjectUnderTest.getSubject();
    }

    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    public void setOuterContext(Evaluator outerContext) {
        this.traverse().setOuterContext(outerContext);
    }

    public Evaluator getNextOuterContext() {
        return this.traverse().getNextOuterContext();
    }

    public Object getOutermostContext() {
        return this.traverse().getOutermostContext();
    }

    public final Traverse traverse() {
        return this.traverse;
    }

    protected void setTraverse(Traverse traverse) {
        this.traverse = traverse;
    }

    public void doTable(Parse table) {
        try {
            this.interpret(new Table(table), this.testResults());
        }
        catch (Exception e) {
            new Table(table).error(this.testResults(), (Throwable)e);
        }
    }

    public void doWithin(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.counts = testResults.getCounts();
        this.interpret(table, testResults);
    }

    public boolean doEmbeddedTablePasses(Table table, Evaluator evaluator, TestResults testResults) {
        return this.traverse().doesInnerTablePass(table, evaluator, testResults);
    }

    public TestResults testResults() {
        return new TestResults(this.counts);
    }

    public Object interpret(Table table, TestResults testResults) {
        return this.traverse().interpret(table, testResults);
    }
}

