/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.closure.MethodTarget;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.collection.array.ArrayParser;
import fitlibrary.collection.list.ListParser;
import fitlibrary.collection.map.MapParser;
import fitlibrary.collection.set.SetParser;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.parse.NoValueProvidedException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

public class CalledMethodTarget
implements MethodTarget {
    private final Closure closure;
    private final Evaluator evaluator;
    private Parser[] parameterParsers;
    protected ResultParser resultParser = null;
    private final Object[] args;
    private String repeatString = null;
    private String exceptionString = null;
    private boolean everySecond = false;

    public CalledMethodTarget(Closure method, Evaluator evaluator) {
        this.closure = method;
        this.evaluator = evaluator;
        this.args = new Object[this.getParameterTypes().length];
        this.parameterParsers = this.closure.parameterParsers(evaluator);
        this.resultParser = this.closure.resultParser(evaluator);
    }

    public CalledMethodTarget(Evaluator evaluator) {
        this.evaluator = evaluator;
        this.parameterParsers = new Parser[0];
        this.args = new Object[0];
        this.closure = null;
        this.resultParser = null;
    }

    public boolean isValid() {
        return this.closure != null;
    }

    private Class getReturnType() {
        return this.closure.getReturnType();
    }

    public Class[] getParameterTypes() {
        return this.closure.getParameterTypes();
    }

    public Object invoke(Object[] arguments) throws Exception {
        return this.closure.invoke(arguments);
    }

    public TypedObject invokeTyped(Object[] arguments) throws Exception {
        return this.closure.invokeTyped(arguments);
    }

    public Object invoke(Cell cell, TestResults testResults) throws Exception {
        this.collectCell(cell, 0, cell.text(), testResults, true);
        return this.invoke(this.args);
    }

    public TypedObject invokeTyped(Row row, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        return this.invokeTyped(this.args);
    }

    public Object invoke(Row row, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        return this.invoke(this.args);
    }

    private void collectCells(Row row, int step, TestResults testResults, boolean catchParseError) throws Exception {
        for (int argNo = 0; argNo < this.args.length; ++argNo) {
            Cell cell = row.cell(argNo * step);
            this.collectCell(cell, argNo, cell.text(), testResults, catchParseError);
        }
    }

    private void collectCell(Cell cell, int argNo, String text, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (!text.equals(this.repeatString)) {
                this.args[argNo] = this.parameterParsers[argNo].parseTyped(cell, testResults).getSubject();
            }
        }
        catch (Exception e) {
            if (catchParseError) {
                cell.error(testResults, e);
                throw new IgnoredException();
            }
            throw e;
        }
    }

    public void invokeAndCheck(Row row, Cell expectedCell, TestResults testResults, boolean handleSubtype) {
        Object result = null;
        boolean exceptionExpected = this.exceptionString != null && this.exceptionString.equals(expectedCell.text());
        try {
            result = this.invoke(row, testResults, true);
            if (exceptionExpected) {
                expectedCell.fail(testResults);
                return;
            }
        }
        catch (IgnoredException ex) {
            return;
        }
        catch (Exception e) {
            if (exceptionExpected) {
                expectedCell.pass(testResults);
            } else {
                expectedCell.error(testResults, e);
            }
            return;
        }
        this.checkResult(expectedCell, result, true, handleSubtype, testResults);
    }

    public String getResult() throws Exception {
        return this.resultParser.show(this.invoke());
    }

    public boolean invokeAndCheckCell(Cell expectedCell, boolean matchedAlready, TestResults testResults) {
        try {
            return this.checkResult(expectedCell, this.invoke(), matchedAlready, false, testResults);
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public Object invoke() throws Exception {
        return this.closure.invoke();
    }

    public boolean matches(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.matches(expectedCell, this.invoke(), testResults);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkResult(Cell expectedCell, Object result, boolean showWrongs, boolean handleSubtype, TestResults testResults) {
        ResultParser valueParser = this.resultParser;
        if (handleSubtype && this.closure != null) {
            valueParser = this.closure.specialisedResultParser(this.resultParser, result, this.evaluator);
        }
        try {
            if (valueParser == null) {
                throw new NoValueProvidedException();
            }
            if (valueParser.isShowAsHtml()) {
                if (valueParser.matches(expectedCell, result, testResults)) {
                    expectedCell.pass(testResults);
                    return true;
                }
                expectedCell.wrongHtml(testResults, valueParser.show(result));
                return false;
            }
            if (valueParser.matches(expectedCell, result, testResults)) {
                expectedCell.passIfNotEmbedded(testResults);
                return true;
            }
            if (showWrongs && (result == null || !expectedCell.hasEmbeddedTable())) {
                expectedCell.fail(testResults, valueParser.show(result));
            }
            return false;
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public Object getResult(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.parseTyped(expectedCell, testResults).getSubject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void color(Row row, boolean right, TestResults testResults) throws Exception {
        if (!this.everySecond && row.cellExists(0)) {
            row.cell(0).passOrFail(testResults, right);
        } else {
            for (int i = 0; i < row.size(); i += 2) {
                row.cell(i).passOrFail(testResults, right);
            }
        }
    }

    public void setRepeatAndExceptionString(String repeatString, String exceptionString) {
        this.repeatString = repeatString;
        this.exceptionString = exceptionString;
    }

    public void setEverySecond(boolean everySecond) {
        this.everySecond = everySecond;
    }

    private Object wrapObjectWithTraverse(TypedObject typedResult) {
        Object result = typedResult.getSubject();
        if (this.isPrimitiveReturnType()) {
            return result;
        }
        if (result instanceof String) {
            return result;
        }
        if (result instanceof Evaluator) {
            Evaluator resultEvaluator = (Evaluator)result;
            if (resultEvaluator != this.evaluator && resultEvaluator.getNextOuterContext() == null) {
                return this.withOuter(resultEvaluator);
            }
            return result;
        }
        if (Traverse.getAlienTraverseHandler().isAlienTraverse(result)) {
            return result;
        }
        Class<?> returnType = result.getClass();
        if (MapParser.applicableType(returnType) || ArrayParser.applicableType(returnType)) {
            return this.withOuter(typedResult.traverse(this.evaluator));
        }
        if (SetParser.applicableType(returnType) || ListParser.applicableType(returnType)) {
            CollectionTraverse traverse = (CollectionTraverse)typedResult.traverse(this.evaluator);
            traverse.setActualCollection(result);
            return this.withOuter(traverse);
        }
        if (ParseDelegation.hasParseMethod(returnType)) {
            return result;
        }
        return this.withOuter(new DoTraverse(typedResult));
    }

    private Object withOuter(Evaluator inner) {
        inner.setOuterContext(this.evaluator);
        return inner;
    }

    private boolean isPrimitiveReturnType() {
        return this.getReturnType().isPrimitive();
    }

    public Object invokeAndWrap(Row row, TestResults testResults) throws Exception {
        return this.wrapObjectWithTraverse(this.invokeTyped(row, testResults, true));
    }

    public String getResultString(Object result) throws Exception {
        if (this.getReturnType() == String.class) {
            return (String)result;
        }
        return this.resultParser.show(result);
    }

    public String toString() {
        return "MethodTarget[" + this.closure + "]";
    }

    public Parser getResultParser() {
        return this.resultParser;
    }

    public void setResultParser(GetterParser resultAdapter) {
        this.resultParser = resultAdapter;
    }

    public Parser[] getParameterParsers() {
        return this.parameterParsers;
    }

    public void setParameterParsers(Parser[] parameterAdapters) {
        this.parameterParsers = parameterAdapters;
    }

    public void setTypedSubject(TypedObject typedObject) {
        this.closure.setTypedSubject(typedObject);
    }

    public boolean returnsVoid() {
        return this.getReturnType() == Void.TYPE;
    }

    public boolean returnsBoolean() {
        return this.getReturnType() == Boolean.TYPE;
    }
}

