/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.closure.MethodTarget;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

public class ClassMethodTarget
implements MethodTarget {
    private Class componentType;
    private Evaluator evaluator;
    private Class actualType;

    public ClassMethodTarget(Class componentType, Evaluator evaluator, TypedObject typedObject) {
        this.componentType = componentType;
        this.evaluator = evaluator;
        this.actualType = typedObject.getClassType();
    }

    public void setTypedSubject(TypedObject typedObject) {
    }

    public String getResult() throws Exception {
        return this.actualType.getName();
    }

    public boolean matches(Cell expectedCell, TestResults testResults) {
        try {
            Class expectedType = LookupMethodTarget.findClassFromFactoryMethod(this.evaluator, this.componentType, expectedCell.text());
            return this.actualType == expectedType;
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public boolean invokeAndCheckCell(Cell expectedCell, boolean matchedAlready, TestResults testResults) {
        try {
            if (this.matches(expectedCell, testResults)) {
                if (matchedAlready) {
                    expectedCell.pass(testResults);
                }
                return true;
            }
            if (matchedAlready) {
                expectedCell.fail(testResults, this.getResult());
            }
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
        }
        return false;
    }

    public String getMethodClass() {
        return "ClassMethodTarget";
    }
}

