/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.method.VoidMethodException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionSetUpTraverse
extends DoTraverse {
    protected CalledMethodTarget target;
    protected int argCount = -1;
    protected boolean boundOK = false;
    protected Collection collection = new ArrayList();
    protected boolean embedded = false;

    public CollectionSetUpTraverse() {
    }

    public CollectionSetUpTraverse(Collection collection) {
        this.collection = collection;
    }

    public CollectionSetUpTraverse(Object sut, Collection collection, boolean embedded) {
        super(sut);
        this.collection = collection;
        this.embedded = embedded;
    }

    public CollectionSetUpTraverse(Object sut) {
        super(sut);
    }

    public Object interpret(Table table, TestResults testResults) {
        this.bindFirstRowToTarget(table.row(1), testResults, this);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow(table.row(i), testResults);
        }
        return this.collection;
    }

    public Object interpretInFlow(Table table, TestResults testResults) {
        this.setUp(table, testResults);
        try {
            this.interpret(table, testResults);
        }
        catch (Exception e) {
            int rowNo = 0;
            if (this.embedded) {
                rowNo = 1;
            }
            table.row(rowNo).error(testResults, e);
        }
        this.tearDown(table, testResults);
        return this.collection;
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults, Evaluator evaluator) {
        try {
            this.argCount = row.size();
            this.target = CollectionSetUpTraverse.findMethodTarget(row, evaluator, this.embedded);
            this.boundOK = true;
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    private static CalledMethodTarget findMethodTarget(Row row, Evaluator evaluator, boolean embedded) {
        ArrayList arguments = new ArrayList();
        String argNames = CollectionSetUpTraverse.buildArguments(row, arguments);
        String methodName = ExtendedCamelCase.camel(argNames);
        CalledMethodTarget findMethod = LookupMethodTarget.findMethod(methodName, arguments, "ResultType", evaluator);
        if (findMethod.returnsVoid() && embedded) {
            throw new VoidMethodException(methodName, "SetUpTraverse");
        }
        return findMethod;
    }

    private static String buildArguments(Row row, List arguments) {
        String argNames = "";
        for (int i = 0; i < row.size(); ++i) {
            String name = row.text(i);
            argNames = argNames + " " + name;
            arguments.add(ExtendedCamelCase.camel(name));
        }
        return argNames;
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.boundOK) {
            row.ignore(testResults);
            return;
        }
        if (row.size() != this.argCount) {
            row.error(testResults, new RowWrongWidthException(this.argCount));
            return;
        }
        try {
            this.invokeMethod(row, testResults);
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    public Object invokeMethod(Row row, TestResults testResults) throws Exception {
        Object result = this.target().invoke(row, testResults, true);
        this.collection.add(result);
        return result;
    }

    public CalledMethodTarget target() {
        return this.target;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public static boolean hasObjectFactoryMethodFor(Table table, Evaluator evaluator) {
        try {
            CollectionSetUpTraverse.findMethodTarget(table.row(0), evaluator, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

