/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.ClassMethodTarget;
import fitlibrary.closure.ConstantMethodTarget;
import fitlibrary.closure.MethodTarget;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.NoSuchPropertyException;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.MapElement;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CollectionTraverse
extends Traverse {
    protected boolean[] usedFields;
    protected Collection actuals;
    protected boolean showSurplus = true;
    private Class componentType = null;

    protected CollectionTraverse(Object sut) {
        super(sut);
    }

    protected CollectionTraverse(Object sut, Object actuals) {
        super(sut);
        this.setActualCollection(actuals);
    }

    public void setActualCollection(Object actuals) {
        if (actuals instanceof Collection) {
            this.setActualCollection((Collection)actuals);
        } else if (actuals instanceof Iterator) {
            this.setActualCollection((Iterator)actuals);
        } else if (actuals instanceof Map) {
            this.setActualCollection((Map)actuals);
        } else if (actuals instanceof Object[]) {
            this.setActualCollection((Object[])actuals);
        } else if (actuals.getClass().isArray()) {
            this.setActualCollectionAsArray(actuals);
        } else {
            throw new RuntimeException("Unable to handle an object of type " + actuals.getClass());
        }
    }

    private void setActualCollectionAsArray(Object actuals) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(actuals);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(actuals, i));
        }
        this.setActualCollection(list);
    }

    public void setActualCollection(Collection actuals) {
        this.actuals = actuals;
    }

    public void setActualCollection(Object[] actuals) {
        this.setActualCollection(Arrays.asList(actuals));
    }

    public void setActualCollection(Iterator it) {
        ArrayList actualCollection = new ArrayList();
        while (it.hasNext()) {
            actualCollection.add(it.next());
        }
        this.setActualCollection(actualCollection);
    }

    public void setActualCollection(Map map) {
        this.setActualCollection(CollectionTraverse.mapMapToSet(map));
    }

    public static List mapMapToSet(Map map) {
        ArrayList<MapElement> elements = new ArrayList<MapElement>();
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            elements.add(new MapElement(key, map.get(key)));
        }
        return elements;
    }

    public Object interpret(Table table, TestResults testResults) {
        if (this.actuals == null) {
            throw new FitLibraryException("Actual list missing");
        }
        Row firstRow = table.row(1);
        try {
            List getters = new ArrayList();
            if (!this.actuals.isEmpty()) {
                getters = this.bindGettersForAllActuals(firstRow, testResults);
            } else if (!table.rowExists(2)) {
                table.row(1).pass(testResults);
            }
            for (int rowNo = 2; rowNo < table.size(); ++rowNo) {
                firstRow = table.row(rowNo);
                this.interpret(firstRow, getters, testResults);
            }
            if (this.showSurplus) {
                this.showSurplus(getters, table, testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            firstRow.error(testResults, e);
        }
        return this.actuals;
    }

    public void setShowSurplus(boolean showSurplus) {
        this.showSurplus = showSurplus;
    }

    public void setComponentType(Class componentType) {
        this.componentType = componentType;
    }

    protected final List bindGettersForAllActuals(Row row, TestResults testResults) throws Exception {
        this.usedFields = new boolean[row.size()];
        for (int i = 0; i < this.usedFields.length; ++i) {
            this.usedFields[i] = false;
        }
        ArrayList<MethodTarget[]> bindings = new ArrayList<MethodTarget[]>();
        Iterator it = this.actuals.iterator();
        while (it.hasNext()) {
            TypedObject typedObject = CollectionTraverse.asTypedObject(it.next());
            bindings.add(this.bindGettersForOneElement(row, testResults, typedObject));
        }
        for (int i = 0; i < this.usedFields.length; ++i) {
            if (this.usedFields[i]) continue;
            String propertyName = this.camelCase(row.cell(i).text());
            String classNames = ClassUtility.allElementClassNames(this.actuals);
            row.cell(i).error(testResults, new NoSuchPropertyException(propertyName, classNames));
            throw new IgnoredException();
        }
        return bindings;
    }

    private MethodTarget[] bindGettersForOneElement(Row row, TestResults testResults, TypedObject typedObject) {
        MethodTarget[] columnBindings = new MethodTarget[row.size()];
        for (int i = 0; i < columnBindings.length; ++i) {
            Cell cell = row.cell(i);
            if (this.componentType != null && DomainObjectSetUpTraverse.givesClass(cell)) {
                columnBindings[i] = new ClassMethodTarget(this.componentType, this, typedObject);
                this.usedFields[i] = true;
                continue;
            }
            String fieldName = ExtendedCamelCase.camel(cell.text());
            try {
                columnBindings[i] = this.bindPropertyGetterForTypedObject(fieldName, typedObject);
                if (columnBindings[i] == null) continue;
                this.usedFields[i] = true;
                continue;
            }
            catch (NoSuchPropertyException e) {
                throw new IgnoredException();
            }
        }
        return columnBindings;
    }

    protected CalledMethodTarget bindPropertyGetterForTypedObject(String name, TypedObject typedObject) {
        String mappedName = this.camelCase(name);
        if (typedObject.getSubject() instanceof Map) {
            Object value = ((Map)typedObject.getSubject()).get(mappedName);
            if (value == null) {
                return null;
            }
            return new ConstantMethodTarget(value, (Evaluator)this);
        }
        return typedObject.optionallyFindGetterOnTypedObject(name, this);
    }

    protected final boolean matchRow(Row row, MethodTarget[] columnBindings, TestResults testResults) throws Exception {
        boolean matchedAlready = false;
        for (int i = 0; i < columnBindings.length; ++i) {
            Cell expectedCell = row.cell(i);
            MethodTarget getter = columnBindings[i];
            if (getter == null) {
                expectedCell.passIfBlank(testResults);
                continue;
            }
            boolean matched = getter.invokeAndCheckCell(expectedCell, matchedAlready, testResults);
            if (!matchedAlready && !matched) {
                return false;
            }
            matchedAlready = true;
        }
        return true;
    }

    protected void showSurplus(List bindings, Table table, TestResults testResults) {
        if (!bindings.isEmpty()) {
            CollectionTraverse.addSurplusRows(table, bindings, testResults);
        }
    }

    private static void addSurplusRows(Table table, List surplusBindings, TestResults testResults) {
        Iterator it = surplusBindings.iterator();
        while (it.hasNext()) {
            MethodTarget[] getter = (MethodTarget[])it.next();
            Row row = table.newRow();
            CollectionTraverse.buildSurplusRow(row, CollectionTraverse.getValues(getter), testResults);
            row.cell(0).actualElementMissing(testResults);
        }
    }

    private static void buildSurplusRow(Row row, Object[] values, TestResults testResults) {
        if (values.length == 0) {
            row.addCell("null", values.length);
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            Cell addCell = row.addCell("&nbsp;");
            Object value = values[i];
            if (value == null) {
                addCell.ignore(testResults);
                continue;
            }
            if (value instanceof Exception) {
                addCell.error(testResults, (Exception)value);
                continue;
            }
            addCell.setUnvisitedEscapedText(value.toString());
        }
    }

    private static Object[] getValues(MethodTarget[] getters) {
        Object[] values = new Object[getters.length];
        for (int i = 0; i < getters.length; ++i) {
            MethodTarget getter = getters[i];
            if (getter == null) {
                values[i] = null;
                continue;
            }
            try {
                values[i] = getter.getResult();
                continue;
            }
            catch (Exception e) {
                values[i] = e;
            }
        }
        return values;
    }

    public abstract void interpret(Row var1, List var2, TestResults var3) throws Exception;
}

