/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.array;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Array;

public class ArrayTraverse
extends Traverse {
    private final Object array;
    private final Parser parser;
    private boolean embedded = false;

    public ArrayTraverse(Object array) {
        this.array = array;
        this.parser = ArrayTraverse.asTyped(array).getComponentTyped().parser(this);
    }

    public ArrayTraverse(Object array, boolean embedded) {
        this(array);
        this.embedded = embedded;
    }

    public Object interpret(Table table, TestResults testResults) {
        Row row;
        int rowNo;
        int offset = 0;
        if (!this.embedded) {
            offset = 1;
        }
        int arrayLength = Array.getLength(this.array);
        int tableSize = table.size();
        if (tableSize == offset && arrayLength == 0 && offset == 1) {
            table.row(0).cell(0).pass(testResults);
        }
        int arrayIndex = 0;
        for (rowNo = offset; rowNo < tableSize && arrayIndex < arrayLength; ++rowNo) {
            row = table.row(rowNo);
            try {
                if (row.size() != 1) {
                    throw new RowWrongWidthException(1);
                }
                if (this.parser.matches(row.cell(0), this.get(arrayIndex), testResults)) {
                    row.pass(testResults);
                    ++arrayIndex;
                    continue;
                }
                row.cell(0).expectedElementMissing(testResults);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        while (rowNo < tableSize) {
            table.row(rowNo).missing(testResults);
            ++rowNo;
        }
        while (arrayIndex < arrayLength) {
            row = table.newRow();
            Cell cell = row.addCell();
            try {
                cell.actualElementMissing(testResults, this.parser.show(this.get(arrayIndex)));
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
            ++arrayIndex;
        }
        return this.array;
    }

    private Object get(int rowNo) {
        return Array.get(this.array, rowNo);
    }
}

