/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.set;

import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.collection.set.SetTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.FitLibrarySelector;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SetParser
implements Parser {
    protected final Parser parser;
    protected final Parser showParser;
    protected final Evaluator evaluator;
    protected final Typed typed;

    public static boolean applicableType(Class type) {
        return Set.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    public SetParser(Evaluator evaluator, Typed typed) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.parser = Traverse.asTyped(String.class).resultParser(evaluator);
        this.showParser = Traverse.asTyped(Object.class).resultParser(evaluator);
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        return this.parse(cell.text(), testResults);
    }

    protected Object parseTable(Table table, TestResults testResults) {
        HashSet set = new HashSet();
        CollectionSetUpTraverse setUp = new CollectionSetUpTraverse(this.evaluator, set, true);
        setUp.interpretInnerTable(table, this.evaluator, testResults);
        return set;
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (result == null) {
            return !cell.hasEmbeddedTable() && cell.isBlank();
        }
        if (cell.hasEmbeddedTable()) {
            return this.tableMatches(cell.getEmbeddedTable(), result, testResults);
        }
        return this.parse(cell, testResults).equals(result);
    }

    protected boolean tableMatches(Table table, Object result, TestResults testResults) {
        CollectionTraverse traverse = FitLibrarySelector.selectSet(result);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    private Object parse(String s, TestResults testResults) throws Exception {
        StringTokenizer t = new StringTokenizer(s, ",");
        HashSet<Object> set = new HashSet<Object>();
        while (t.hasMoreTokens()) {
            set.add(this.parser.parseTyped(new Cell(t.nextToken()), testResults).getSubject());
        }
        return set;
    }

    public String show(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        if (object == null) {
            return "";
        }
        String result = "";
        boolean first = true;
        Set set = (Set)object;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String element = this.showParser.show(it.next());
            if (first) {
                first = false;
            } else {
                result = result + ", ";
            }
            result = result + element;
        }
        return result;
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            public Parser parser(Evaluator evaluator, Typed typed) {
                return new SetParser(evaluator, typed);
            }
        };
    }

    public Evaluator traverse(TypedObject typedObject) {
        return new SetTraverse((Object)typedObject);
    }
}

