/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.debug;

import fit.Counts;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.debug.GrabPage;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.io.IOException;

public class DebugPage {
    protected int tablesFinished = 0;
    protected int storytestsFinished = 0;
    protected int expectedTablesFinished = 0;
    protected FixtureListener fixtureListener = new FixtureListener(){

        public void tableFinished(Parse table) {
            ++DebugPage.this.tablesFinished;
        }

        public void tablesFinished(Counts count) {
            ++DebugPage.this.storytestsFinished;
        }
    };
    BatchFitLibrary batchFitLibrary = new BatchFitLibrary(new TableListener(this.fixtureListener));
    private GrabPage grabPage;

    public static void main(String[] args) throws Exception {
        String url = "http://localhost:8980/";
        String[] pageNames = new String[]{"BatchFitLibraryInFitNesse"};
        DebugPage.run(url, pageNames);
    }

    public static void run(String url, String[] pageNames) throws Exception {
        DebugPage runPage = new DebugPage(url);
        runPage.runs(pageNames);
    }

    public DebugPage(String url) {
        this.grabPage = new GrabPage(url);
    }

    public void runs(String[] pageNames) throws FitParseException, IOException {
        this.tablesFinished = 0;
        this.storytestsFinished = 0;
        for (int i = 0; i < pageNames.length; ++i) {
            this.run(pageNames[i]);
            if (this.storytestsFinished == i + 1) continue;
            throw new RuntimeException("Wrong # of FixtureListener events fired for " + pageNames[i] + ": " + this.storytestsFinished + " instead of " + (i + 1));
        }
        if (this.tablesFinished != this.expectedTablesFinished) {
            throw new RuntimeException("Expected FixtureListener events for " + this.expectedTablesFinished + " tables but instead got " + this.tablesFinished);
        }
    }

    public void run(String pageName) throws IOException, FitParseException {
        String html = this.grabPage.grabPage(pageName);
        Parse parse = new Parse(html);
        System.out.println("\n----------\nHTML for " + pageName + "\n----------\n" + html);
        Tables tables = new Tables(parse);
        this.expectedTablesFinished += tables.size();
        TestResults testResults = this.batchFitLibrary.doTables(tables);
        System.out.println("\n----------\nHTML Report for " + pageName + "\n----------\n" + ParseUtility.toString(parse));
        System.out.println(testResults);
    }
}

