/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.LocalFile;
import fitlibrary.utility.StringUtility;
import java.io.File;

public class FitNesseLocalFile
implements LocalFile {
    protected static final String LOCAL_FILES = "/files";
    protected static final String FITNESSE_FILES_LOCATION = "FitNesseRoot/files";
    private String fileName;

    public FitNesseLocalFile(String fileName) {
        this.setFileName(fileName);
    }

    public FitNesseLocalFile(File file) {
        String path = file.getPath();
        this.setFileName(StringUtility.replaceString(path, "\\", "/"));
    }

    private void setFileName(String fileName) {
        String prefix = "/files/";
        this.fileName = fileName.startsWith("/files/") ? fileName.substring("/files/".length()) : fileName;
    }

    public LocalFile withSuffix(String suffix) {
        String name = this.fileName;
        int last = this.fileName.lastIndexOf(".");
        if (last >= 0) {
            name = name.substring(0, last + 1) + suffix;
        }
        return new FitNesseLocalFile(name);
    }

    public File getFile() {
        if (this.fileName.startsWith("/") || this.fileName.charAt(1) == ':') {
            return new File(this.fileName);
        }
        return new File("FitNesseRoot/files/" + this.fileName);
    }

    public void mkdir() {
        File file = this.getFile();
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String htmlImageLink() {
        return "<img src=\"/files/" + this.fileName + "\">";
    }

    public String htmlLink() {
        String name = this.fileName;
        int last = this.fileName.lastIndexOf("/");
        if (last >= 0) {
            name = name.substring(last + 1);
        }
        return "<a href=\"/files/" + this.fileName + "\">" + name + "</a>";
    }

    public boolean equals(Object object) {
        if (!(object instanceof FitNesseLocalFile)) {
            return false;
        }
        return this.fileName.equals(((FitNesseLocalFile)object).fileName);
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public String toString() {
        return "FitNesseLocalFile[" + this.fileName + "]";
    }
}

