/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.object.DomainTraverse;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.SwitchingEvaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class DomainInjectionTraverse
extends Traverse
implements SwitchingEvaluator {
    private DomainTraverse domainTraverse = null;

    public void setDomainTraverse(DomainTraverse domainTraverse) {
        this.domainTraverse = domainTraverse;
    }

    public void runTable(Table table, TableListener tableListener) {
        if (this.switchOnActions(table)) {
            this.domainTraverse.setCurrentAction();
            return;
        }
        if (this.switchOnChecks(table)) {
            this.domainTraverse.setCurrentCheck();
            return;
        }
        try {
            for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                this.processRow(table.row(rowNo), tableListener.getTestResults());
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            table.error(tableListener, e);
        }
    }

    private boolean switchOnActions(Table table) {
        return this.domainTraverse != null && table.size() == 1 && table.row(0).size() == 1 && table.row(0).cell(0).matchesText("actions");
    }

    private boolean switchOnChecks(Table table) {
        return this.domainTraverse != null && table.size() == 1 && table.row(0).size() == 1 && table.row(0).cell(0).matchesText("checks");
    }

    public void processRow(Row row, TestResults testResults) {
        for (int i = 0; i < row.size(); i += 2) {
            Cell cell = row.cell(i);
            try {
                CalledMethodTarget target = LookupMethodTarget.findSetter(cell.text(), this);
                Cell nextCell = row.cell(i + 1);
                try {
                    target.invoke(nextCell, testResults);
                }
                catch (IgnoredException e) {
                }
                catch (Exception e) {
                    nextCell.error(testResults, e);
                }
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
    }

    public Object interpret(Table table, TestResults testResults) {
        table.error(testResults, (Throwable)new RuntimeException("Don't expect to have this called!"));
        return null;
    }
}

