/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.classes.ConstructorNotVisible;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.exception.classes.NotSubclassFromClassFactoryMethod;
import fitlibrary.exception.classes.NullFromClassFactoryMethod;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.TestResults;

public class DomainObjectSetUpTraverse
extends Traverse {
    private Class type;

    public DomainObjectSetUpTraverse(Object sut) {
        super(sut);
    }

    public DomainObjectSetUpTraverse(TypedObject typedObject, Typed typed) {
        super(typedObject);
        this.type = typed.asClass();
    }

    public Object interpret(Table table, TestResults testResults) {
        if (this.type != null) {
            this.createObjectOfSpecifiedType(table, testResults);
        }
        for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
            this.processRow(table.row(rowNo), testResults);
        }
        try {
            this.callEndCreatingObjectMethod(this.getTypedSystemUnderTest());
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return this.getSystemUnderTest();
    }

    private void createObjectOfSpecifiedType(Table table, TestResults testResults) {
        for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
            Row row = table.row(rowNo);
            for (int i = 0; i < row.size(); i += 2) {
                if (!DomainObjectSetUpTraverse.givesClass(row.cell(i))) continue;
                this.createSystemUnderTest(row.cell(i + 1), testResults);
                return;
            }
        }
        if (this.getSystemUnderTest() == null) {
            throw new NoNullaryConstructor(this.type);
        }
    }

    private void createSystemUnderTest(Cell cell, TestResults testResults) {
        Class sutClass = null;
        try {
            String typeName = cell.text();
            sutClass = LookupMethodTarget.findClassFromFactoryMethod(this, this.type, typeName);
            if (sutClass == null) {
                throw new NullFromClassFactoryMethod(typeName);
            }
            if (!this.type.isAssignableFrom(sutClass)) {
                throw new NotSubclassFromClassFactoryMethod(sutClass, this.type);
            }
            Object newInstance = ClassUtility.newInstance(sutClass);
            this.setSystemUnderTest(newInstance);
            this.callStartCreatingObjectMethod(newInstance);
        }
        catch (IllegalAccessException e) {
            cell.error(testResults, new ConstructorNotVisible(sutClass.getName()));
        }
        catch (NoSuchMethodException e) {
            cell.error(testResults, new NoNullaryConstructor(sutClass.getName()));
        }
        catch (Exception e) {
            cell.error(testResults, e);
        }
    }

    public void processRow(Row row, TestResults testResults) {
        for (int i = 0; i < row.size(); i += 2) {
            Cell cell = row.cell(i);
            if (DomainObjectSetUpTraverse.givesClass(cell)) continue;
            if (this.getSystemUnderTest() == null) {
                cell.ignore(testResults);
                continue;
            }
            try {
                CalledMethodTarget target = LookupMethodTarget.findSetter(cell.text(), this);
                DomainObjectSetUpTraverse.callSetter(target, row.cell(i + 1), testResults);
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
    }

    public static boolean givesClass(Cell cell) {
        return cell.isBlank() && !cell.hasEmbeddedTable();
    }

    private static void callSetter(CalledMethodTarget target, Cell nextCell, TestResults testResults) {
        try {
            target.invoke(nextCell, testResults);
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            nextCell.error(testResults, e);
        }
    }
}

