/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.exception.NoSystemUnderTestException;
import fitlibrary.object.DomainCheckTraverse;
import fitlibrary.object.DomainInjectionTraverse;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.SwitchingEvaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class DomainTraverse
extends DoTraverse
implements SwitchingEvaluator {
    private DomainInjectionTraverse domainInject = new DomainInjectionTraverse();
    private DomainCheckTraverse domainCheck = new DomainCheckTraverse();
    private SwitchingEvaluator current = this.domainInject;

    public DomainTraverse(Object sut) {
        super(sut);
        this.domainInject.setDomainTraverse(this);
        this.domainCheck.setDomainTraverse(this);
        this.setSystemUnderTest(sut);
    }

    public void runTable(Table table, TableListener tableListener) {
        super.interpretWholeTable(table, tableListener);
    }

    public void setSystemUnderTest(Object sut) {
        super.setSystemUnderTest(sut);
        if (this.domainCheck != null) {
            this.domainCheck.setSystemUnderTest(sut);
        }
        if (this.domainInject != null) {
            this.domainInject.setSystemUnderTest(sut);
        }
    }

    public void checks(Row row, TestResults testResults) {
        this.setCurrentCheck();
    }

    public Object interpretWholeTable(Table table, TableListener tableListener) {
        if (this.current == null) {
            throw new NoSystemUnderTestException();
        }
        int phaseBreaks = table.phaseBreaks();
        if (phaseBreaks > 0) {
            for (int i = 0; i < phaseBreaks; ++i) {
                if (this.current == this.domainInject) {
                    this.setCurrentAction();
                    continue;
                }
                if (this.current == this) {
                    this.setCurrentCheck();
                    continue;
                }
                this.current = this.domainInject;
            }
        }
        this.current.runTable(table, tableListener);
        return this.current;
    }

    public void setCurrentCheck() {
        this.current = this.domainCheck;
    }

    public void setCurrentAction() {
        this.current = this;
    }
}

