/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser;

import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

public class DelegatingParser
implements Parser {
    protected final DelegateParser delegateParser;
    protected final Evaluator evaluator;
    protected final Typed typed;

    public DelegatingParser(DelegateParser delegateParser, Evaluator evaluator, Typed typed) {
        this.delegateParser = delegateParser;
        this.evaluator = evaluator;
        this.typed = typed;
    }

    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        try {
            return this.delegateParser.parse(cell.text());
        }
        catch (NumberFormatException e) {
            throw new BadNumberException();
        }
    }

    protected Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        Object newInstance = this.typed.newInstance();
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance);
        setUp.callStartCreatingObjectMethod(newInstance);
        setUp.interpretInnerTable(embeddedTable, this.evaluator, testResults);
        setUp.callEndCreatingObjectMethod(newInstance);
        return newInstance;
    }

    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTable()) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.delegateParser.matches(this.parse(cell, testResults), result);
    }

    protected boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator, testResults);
    }

    public String show(Object result) throws Exception {
        return this.delegateParser.show(result);
    }

    public String toString() {
        return this.delegateParser.toString();
    }

    public Evaluator traverse(TypedObject object) {
        throw new RuntimeException("No Traverse available");
    }
}

