/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.graphic;

import fitlibrary.differences.LocalFile;
import fitlibrary.log.Logging;
import fitlibrary.parser.graphic.GraphicInterface;
import fitlibrary.traverse.Traverse;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class DotGraphic
implements GraphicInterface {
    private static final Random random = new Random(System.currentTimeMillis());
    protected String dot;

    public DotGraphic(String dot) {
        this.dot = dot;
    }

    public static DotGraphic parseGraphic(LocalFile file) {
        return new DotGraphic(DotGraphic.getDot(file));
    }

    public boolean equals(Object other) {
        if (!(other instanceof DotGraphic)) {
            return false;
        }
        boolean equals = this.dot.equals(((DotGraphic)other).dot);
        Logging.log(this, "equals(): '" + this.dot + "' and '" + other + "' equals=" + equals);
        return equals;
    }

    public LocalFile toGraphic() {
        try {
            LocalFile actualImageFile = this.actualImageFile(this.dot);
            Logging.log(this, "toGraphic(): '" + actualImageFile + "'");
            return actualImageFile;
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem with Dot: " + ex);
        }
    }

    public String toString() {
        String htmlImageLink = this.toGraphic().htmlImageLink();
        Logging.log(this, "toString(): '" + htmlImageLink + "'");
        return htmlImageLink;
    }

    private LocalFile actualImageFile(String actualDot) throws IOException {
        String actuals = "tempActuals";
        String actualName = "tempActuals/actual" + random.nextInt(999999);
        Traverse.getLocalFile("tempActuals").mkdir();
        File dotFile = Traverse.getLocalFile(actualName + ".dot").getFile();
        FileWriter writer = new FileWriter(dotFile);
        writer.write(actualDot);
        writer.close();
        LocalFile imageFileName = Traverse.getLocalFile(actualName + ".gif");
        File imageFile = imageFileName.getFile();
        Process process = Runtime.getRuntime().exec("dot -Tgif \"" + dotFile.getAbsolutePath() + "\" -o \"" + imageFile.getAbsolutePath() + "\"");
        try {
            process.waitFor();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Dot process timed out.");
        }
        if (process.exitValue() != 0) {
            throw new RuntimeException("Problems with actual Dot:\n" + actualDot);
        }
        return imageFileName;
    }

    private static String getDot(LocalFile file) {
        return DotGraphic.getFileContents(file.withSuffix("dot").getFile());
    }

    private static String getFileContents(File file) {
        try {
            FileReader reader = new FileReader(file);
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            return new String(chars);
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem reading " + file.getAbsolutePath() + ": " + ex);
        }
    }
}

