/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.parser.DelegateParser;
import fitlibrary.parser.DelegatingParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ParseDelegation {
    private static Map PARSE_DELEGATES = new HashMap();

    public static void registerParseDelegate(Class type, Class parseDelegate) {
        DelegateClassParser delegate = DelegateClassParser.findDelegate(parseDelegate);
        if (delegate == null) {
            throw new RuntimeException("Parse delegate class " + parseDelegate.getName() + " does not have a suitable static parse() method.");
        }
        PARSE_DELEGATES.put(type, delegate);
    }

    public static void registerParseDelegate(Class type, Object parseDelegate) {
        try {
            DelegateObjectParser delegate = new DelegateObjectParser(parseDelegate);
            PARSE_DELEGATES.put(type, delegate);
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate object of class " + parseDelegate.getClass().getName() + " does not have a suitable parse() method.");
        }
    }

    public static void clearDelegatesForNextTest() {
        PARSE_DELEGATES.clear();
    }

    public static boolean hasParseMethod(Class type) {
        return ParseDelegation.findParseMethod(type) != null;
    }

    public static Method findParseMethod(Class type) {
        try {
            Method method = type.getMethod("parse", String.class);
            int modifiers = method.getModifiers();
            Class<?> returnType = method.getReturnType();
            if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && returnType != Void.class && !returnType.isPrimitive()) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static DelegateParser getDelegate(Class type) {
        return (DelegateParser)PARSE_DELEGATES.get(type);
    }

    public static ParserFactory delegateClassFactory(Typed typed) {
        final DelegateClassParser classParser = DelegateClassParser.findDelegate(typed.asClass());
        if (classParser != null) {
            return new ParserFactory(){

                public Parser parser(Evaluator evaluator, Typed typed2) {
                    return new DelegatingParser(classParser, evaluator, typed2);
                }
            };
        }
        return null;
    }

    static class DelegateObjectParser
    extends DelegateParser
    implements Cloneable {
        private Object delegate;
        private Method parseMethod;

        public DelegateObjectParser(Object delegate) throws SecurityException, NoSuchMethodException {
            super(null);
            this.delegate = delegate;
            this.parseMethod = delegate.getClass().getMethod("parse", class$java$lang$String == null ? (class$java$lang$String = ParseDelegation.class$("java.lang.String")) : class$java$lang$String);
        }

        public Object parse(String s) throws Exception {
            return this.parseMethod.invoke(this.delegate, s);
        }
    }

    static class DelegateClassParser
    extends DelegateParser
    implements Cloneable {
        private Method parseMethod;

        public static DelegateClassParser findDelegate(Class type) {
            Method parseMethod = ParseDelegation.findParseMethod(type);
            if (parseMethod == null) {
                return null;
            }
            return new DelegateClassParser(parseMethod);
        }

        public DelegateClassParser(Method parseMethod) {
            this.parseMethod = parseMethod;
        }

        public Object parse(String s) throws Exception {
            return this.parseMethod.invoke(null, s);
        }
    }
}

