/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fitlibrary.runner.CustomRunnerException;
import fitlibrary.runner.MakeParse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class CustomRunner
extends MakeParse {
    protected Fixture fixture = new Fixture();
    private File reportFile = null;

    public CustomRunner(String webPageTitle, File inFile, String reportFileName) {
        this(webPageTitle, inFile, new File(reportFileName));
    }

    public CustomRunner(String webPageTitle, File inFile, File reportFile) {
        super(webPageTitle);
        this.reportFile = reportFile;
        if (inFile != null) {
            this.fixture.summary.put("input file", inFile.getAbsolutePath());
            this.fixture.summary.put("input update", new Date(inFile.lastModified()));
        }
        if (reportFile != null) {
            this.fixture.summary.put("output file", reportFile.getAbsolutePath());
        }
    }

    public CustomRunner(String webPageTitle, String reportFileName) {
        this(webPageTitle, null, reportFileName);
    }

    public CustomRunner(String webPageTitle) {
        this(webPageTitle, "report.html");
    }

    public CustomRunner() {
        this("CustomRunner");
    }

    public CustomRunner(String webPageTitle, CustomRunner previousRunner) {
        this(webPageTitle);
        this.fixture.counts = previousRunner.fixture.counts;
    }

    public void runAndReportAndExit() throws IOException, CustomRunnerException {
        System.exit(this.runAndReportCounts());
    }

    public int runAndReportCounts() throws IOException, CustomRunnerException {
        this.runAndReport();
        System.err.println(this.fixture.counts());
        return this.errorCount();
    }

    public Counts runAndReport() throws IOException, CustomRunnerException {
        this.run();
        this.print();
        return this.fixture.counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() throws IOException {
        PrintWriter report = new PrintWriter(new BufferedWriter(new FileWriter(this.reportFile)));
        try {
            this.print(report);
        }
        finally {
            report.close();
        }
    }

    public void run() throws RuntimeException {
        Parse tables = this.getTables();
        if (tables != null) {
            this.fixture.doTables(tables);
        }
    }

    public int errorCount() {
        return this.fixture.counts.wrong + this.fixture.counts.exceptions;
    }
}

